<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DateTime;

class OnlineTransactionController extends Controller
{
    
    public function OnlineTransaction(Request $request)
    {

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
            if (auth()->user()->role=="Administrator") {
                $onlineReport = \DB::table('online_customers')
                ->where('order_state', $request->state)
                ->whereDate('date', $from)
                ->get();
            }else {
                $onlineReport = \DB::table('online_customer')
                ->where('order_state', $request->state)
                ->whereDate('date', $from)
                ->where('branch', auth()->user()->branch)
                ->get();
            }
            return view('inc.print-online-transactions', [
                'onlineReport' => $onlineReport
            ]);
        }else {
            if (auth()->user()->role=="Administrator") {
                $onlineReport = \DB::table('online_customers')
                ->where('order_state', $request->state)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->get();
            }else {
                $onlineReport = \DB::table('online_customer')
                ->where('order_state', $request->state)
                ->WhereDate('date','>=', $from)
                ->WhereDate('date','<=', $to)
                ->where('branch', auth()->user()->branch)
                ->get();
            }
            return view('inc.print-online-transactions', [
                'onlineReport' => $onlineReport
            ]);
        }
    }
}
