<?php

namespace App\Http\Controllers;

use App\Models\PrintCount;
use Illuminate\Http\Request;

class PrintCountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        return $this->middleware('auth');
    }
    
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($id)
    {   
        $order_id = $id;
        $print = PrintCount::where('order_number', $order_id)->first();

        if (!is_null($print)) {
            $print->update([
                'counts' => $print->counts + 1
            ]);
        }else{
            $print = PrintCount::create([
                'order_number' => $order_id,
            'counts' => 1
            ]);
        }

        return $print->counts;

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PrintCount  $printCount
     * @return \Illuminate\Http\Response
     */
    public function show(PrintCount $printCount)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\PrintCount  $printCount
     * @return \Illuminate\Http\Response
     */
    public function edit(PrintCount $printCount)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\PrintCount  $printCount
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PrintCount $printCount)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\PrintCount  $printCount
     * @return \Illuminate\Http\Response
     */
    public function destroy(PrintCount $printCount)
    {
        //
    }
}
