<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CustomerStatement;
use App\Models\LoyaltyPoint;
use App\Models\LoyaltyRatio;
use App\Models\Invoice;
use App\Models\InvoiceDump;
use App\Models\User;
use App\Models\Customer;
use App\Models\Waiting;
use App\Models\Order;
use App\Models\Discount;
use Carbon\carbon;
use Illuminate\Support\Facades\Http;
use DateTime;
use App\Models\CompositionRecord;
use App\Models\CostOfSaleAnalysis;
use App\Models\InventoryReport;
use App\Models\TargetAnalysis;
use App\Models\BomReportOnSale;
use App\Models\BarTable;

class PrinterController extends Controller
{
    public function PrintLite(Request $request, $inv , $id)
    {   
        
        $salesperson = Order::where('order_id', $inv)->first();
        if (empty($salesperson) || null) {
            abort(419, "Unauthorized Access");
        }
        
        $name = $salesperson->user->name;
        $branch = $salesperson->user->branch;
        $role = $salesperson->user->role;
        


        return view('print-lite', [
            'customer' => \DB::table('customers')->where('id', $id)->first(),
            'invoice_generate' => Invoice::where('invoice_number', $inv)->get(),
            'number' => $inv,
            'total' => Invoice::where('invoice_number', $inv)->sum('invoice_total_price'),
            'branch_details' => \DB::table('branches')->where('branch_name',$salesperson->branch)->first(),
            'discount' => \DB::table('discounts')->where('order_id', $inv)->first(),
            'sales_person_name' => $name,
            'sales_person_branch' => $branch,
            'time' => $salesperson -> created_at,
            'agency_' => Invoice::where('invoice_number', $inv)->first(),
            'amount_paid' => Order::where('order_id',$inv)->first(),
            'amount_paid_sales' => $salesperson -> amount_paid,
            'user_role_' => $role,
         
        ]);
    }
}
