<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\RegisterTable;

class RegisterTableController extends Controller
{
    public function index()
    {
        return view('tables.new-table', [
            'tables' => RegisterTable::all()
        ]);
    }



    public function create()
    {
        $this->validate_table();
        $data = [
            'user_id' => auth()->id(),
            'table_name' => request('table_name'),
            'table_description' => request('table_description'),
        ];
        RegisterTable::create($data);
        return back()->with('status', 'Table created Successfully');
    }


    public function update(RegisterTable $table)
    {   
        $this->validate_table();
        $data = [
            'table_name' => request('table_name'),
            'table_description' => request('table_description'),
        ];
        $table->update($data);
        return back()->with('status', 'Table Updated Successfully');
    }


    public function destroy(RegisterTable $table)
    {
        $table->delete();
        return back()->with('status', "Table Removed Successfully");
    }


    public function validate_table()
    {
        $this->validate(request(), [
            'table_name' => 'required|max:200'
        ]);
    }
}
