<?php

namespace App\Http\Controllers;

use App\Models\Remark;
use Illuminate\Http\Request;
use Carbon\carbon;

class RemarkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    
    public function index()
    {   
        $remark_category = \DB::table('remarks')
            ->selectRaw('remark_category as category, count(*) as total_remarks')
            ->groupBy('remark_category')
            ->get();

        $remark_pizzaman = \DB::table('remarks')
            ->selectRaw('remark_pizzaman as remark_pizzaman, count(*) as total_class')
            ->groupBy('remark_pizzaman')
            ->where('remark_pizzaman','!=', null)
            ->get();

        $remark_chickenman = \DB::table('remarks')
            ->selectRaw('remark_chickenman as remark_chickenman, count(*) as total_class')
            ->groupBy('remark_chickenman')
            ->where('remark_chickenman','!=', null)
            ->get();


        $top_customers = \DB::table('customers')
        ->join('invoices', 'customers.id', 'invoices.customer_id')
        ->selectRaw('customers.customer_name as name, sum(invoice_total_price) as total, customers.id as id')
        ->groupBy('customers.customer_name')
        ->groupBy('customers.id')
        ->orderBy('total', "DESC")
        ->whereDate('invoices.created_at', '>=', Carbon::now()->subDays(30))
        ->where('invoice_category', '!=', "TRANSPORT")
        ->paginate(10);
        
        $reviews =  \DB::table('remarks')
            ->select('*')
            ->join('customers', 'remarks.customer_id', 'customers.id')
            ->OrderBy('remarks.created_at', 'DESC')
            ->paginate(10);

        $customers =  \DB::table('customers') -> get();
        $orders =  \DB::table('orders') ->where('category', "Delivery")-> get();
        $total_orders =  \DB::table('orders') ->where('category', "Delivery")-> sum('total_cost_order');
        $products =  \DB::table('final_productions') -> get();


        return view('customer.customers-review-summary', [
            'review' => $reviews,
            'customer_total' => $customers,
            'orders_total' => $orders,
            'total_orders' => $total_orders,
            'products' => $products,
            'remark_category' =>  $remark_category,
            'top_customers' => $top_customers,
            'remark_pizzaman' => $remark_pizzaman,
            'remark_chickenman' => $remark_chickenman
        ]);
    }


    public function category($category)
    {
        $remarks_display =  \DB::table('remarks')
        ->select('*')
        ->join('customers', 'remarks.customer_id', 'customers.id')
        ->OrderBy('remarks.created_at', 'DESC')
        ->where('remarks.remark_category', $category)->get();

        return view('review-category', [
            'remarks_display' => $remarks_display,
            'category' => $category
        ]);
    }


    public function categoryDepartmentPizzaman($category)
    {
        $remarks_display =  \DB::table('remarks')
        ->select('*')
        ->join('customers', 'remarks.customer_id', 'customers.id')
        ->OrderBy('remarks.created_at', 'DESC')
        ->where('remarks.remark_pizzaman', $category)->get();

        return view('review-category', [
            'remarks_display' => $remarks_display,
            'category' => $category
        ]);
    }


    public function categoryDepartmentChickenman($category)
    {
        $remarks_display =  \DB::table('remarks')
        ->select('*')
        ->join('customers', 'remarks.customer_id', 'customers.id')
        ->OrderBy('remarks.created_at', 'DESC')
        ->where('remarks.remark_chickenman', $category)->get();

        return view('review-category', [
            'remarks_display' => $remarks_display,
            'category' => $category
        ]);
    }

    public function preview($id)
    {
        return Remark::findOrfail($id);
    }

    public function classification($classification)
    {
       return $remarks_display =  \DB::table('remarks')
        ->select('*')
        ->join('customers', 'remarks.customer_id', 'customers.id')
        ->OrderBy('remarks.created_at', 'DESC')
        ->where('remarks.remark_classification', $classification)->get();

        return view('review-classification', [
            'remarks_display' => $remarks_display,
            'classification' => $classification
        ]);
    }



    public function store(Request $request)
    {
        $this->validate($request, [
            'remark_category' => 'required',
            'contact_status' => 'required',
            'remark' => 'required|max:350'
        ]);

        $data = new Remark;
        $data -> user_id  = auth()->user()->id;
        $data -> customer_id = $request -> customer;
        $data -> order_number = $request -> order;
        $data -> remark = $request -> remark;
        $data -> remark_category = $request -> remark_category;
        $data -> remark_pizzaman = $request -> remark_pizzaman;
        $data -> remark_chickenman = $request -> remark_chickenman;
        $data -> remark_call = $request -> remark_call;
        $data -> remark_classification = $request -> remark_classification;
        $data -> contact_status = $request -> contact_status;
        $data -> save();
        return back()->with('status', "Remark Added Successfully");
    }




    
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Remark  $remark
     * @return \Illuminate\Http\Response
     */
    public function show(Remark $remark)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Remark  $remark
     * @return \Illuminate\Http\Response
     */
    public function edit(Remark $remark)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Remark  $remark
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Remark $remark)
    {
        $this->validate($request, [
            'remark_category' => 'required',
            'contact_status' => 'required',
            'remark' => 'required|max:350'
        ]);

        $remark -> user_id  = auth()->user()->id;
        $remark -> customer_id = $request -> customer_id;
        $remark -> order_number = $request -> order;
        $remark -> remark = $request -> remark;
        $remark -> remark_category = $request -> remark_category;
        $remark -> remark_pizzaman = $request -> remark_pizzaman;
        $remark -> remark_chickenman = $request -> remark_chickenman;
        $remark -> remark_call = $request -> remark_call;
        $remark -> remark_classification = $request -> remark_classification;
        $remark -> contact_status = $request -> contact_status;
        $remark -> save();

        return back()->with('status', 'Review updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Remark  $remark
     * @return \Illuminate\Http\Response
     */
    public function destroy(Remark $remark)
    {
        //
    }
}
