<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Invoice;
use DateTime;
use App\Models\User;
use Carbon\carbon;

class ReportController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }


    public function reportByDate(Request $request)
    {
        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->get();


        $total_sales = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        
            // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->get();
        
        $discounts = \DB::table('discounts')
                ->whereDate('created_at', $from)
                ->sum('amount_deducted');

        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $general_total_general = ($total_sales)-($discounts);


        return view('sales.general-sales-report', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'total_deliveries' => $total_deliveries
            
        ]);
    }else {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $total_sales = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');


        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $deliveryfee = \DB::table('dispatches')
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('dispatch_status', 1)
        ->where('status', 1)
        ->sum('deliveryamount');

        $discounts = \DB::table('discounts')
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->sum('amount_deducted');

        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $general_total_general = $total_sales-($discounts);


        return view('sales.general-sales-report', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'total_deliveries' => $total_deliveries
            
        ]);
        }

    }




    public function dateReportByUser(Request $request)
    {
         // getDay close
       $getDayClose = \DB::table('close_days')->first();

        // find user
        $user_data = User::findOrfail($request->user_id);
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();
        
        $user = User::findOrfail($request->user_id);
        // general Sales
        if ($user->sales_person_category == "Delivery") {
            $inv = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('user_id', $request->user_id)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

                
        }elseif($user->sales_person_category == "Counter") {
           $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');
        }elseif ($user->sales_person_category == "Drive Thru") {
            $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');
        }

        $deliveryAmount = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');
        

        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        $order =  \DB::table('orders')
        ->where('user_id', $request->user_id)
        ->whereDate('created_at', $from)
        ->get();

        $orders = \DB::table('invoices')
        ->where('user_id', $request->user_id)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $getDayClose->day_close)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
                ->where('user_id', $request->user_id)
                ->whereDate('created_at', $from)
                ->sum('amount_deducted');

        $general_total_general = $inv - $discounts;



        return view('sales.general-sales-report-byuser', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'user_data' => $user_data,
            'order' => $order,
            'discounts' => $discounts,
            'orders' => $orders,
            'inv' => $inv,
            'deliveryAmount' => $deliveryAmount
        ]);
    }else {
        $sales_today_general = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $user = User::findOrfail($request->user_id);
        // general Sales
        if ($user->sales_person_category == "Delivery") {
            $inv = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        }else {
            $inv = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('user_id', $request->user_id)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->sum('invoice_total_price');
        }

        $discounts = \DB::table('discounts')
                ->where('user_id', $request->user_id)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->sum('amount_deducted');

        $deliveryAmount = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $general_total_general = $inv - $discounts;

        // On the House
        $general_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $general_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $general_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $order =  \DB::table('orders')
        ->where('user_id', $request->user_id)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $orders = \DB::table('invoices')
        ->where('user_id', $request->user_id)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->where('user_id', $request->user_id)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('amount_deducted');

        

            $general_total_general = $inv - $discounts;
       

        return view('sales.general-sales-report-byuser', 
        [
            'sales_today_general' => $sales_today_general,
            'general_total_general' => $general_total_general,
            'general_total_house' => $general_total_house,
            'general_total_reject' => $general_total_reject,
            'general_total_reject_list' => $general_total_reject_list,
            'general_total_house_list' => $general_total_house_list,
            'user_data' => $user_data,
            'order' => $order,
            'discounts' => $discounts,
            'orders' => $orders,
            'deliveryAmount' => $deliveryAmount
        ]);
        }

    }


    public function branchSalesReport(Request $request)
    {

        $value = explode(' - ', $request->date);
         

        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_branch = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->get();

        $total_cash = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        
        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->sum('amount_deducted');
        
       $branch_total_general = $total_cash - $discounts;

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->whereDate('created_at', $from)
        ->get();

        $orders = \DB::table('orders')
        ->select('*')
        ->join('users','users.id', 'orders.user_id')
        ->where('orders.branch', $request->branch)
        ->whereDate('orders.created_at', $from)
        ->get();
        
        $users_all = \DB::table('users')
        ->where('branch', $request->branch)
        ->get();


        $total_deliveries = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->sum('invoice_total_price');


        return view('sales.general-sales-report-branch', [
            'sales_today_branch' => $sales_today_branch,
            'from' => $from,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'all_orders' => $orders,
            'users_all' => $users_all,
            'total_deliveries' => $total_deliveries
            
        ]);
     }else {
        $sales_today_branch = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $total_cash = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');



        $branch_total_general = $total_cash;
                    
        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 2)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_status', 0)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $orders = \DB::table('orders')
        ->select('*')
        ->join('users','users.id', 'orders.user_id')
        ->where('orders.branch', $request->branch)
        ->whereBetween('orders.created_at', [$from, $to])
        ->get();

        $users_all = \DB::table('users')
        ->where('branch', $request->branch)
        ->get();

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->sum('amount_deducted');
        
       $branch_total_general = $total_cash - $discounts;

       $total_deliveries = \DB::table('invoices')
       ->where('invoice_status', 1)
       ->where('invoice_category', "TRANSPORT")
       ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
       ->where('branch', $request->branch)
       ->sum('invoice_total_price');

       
        return view('sales.general-sales-report-branch', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'all_orders' => $orders,
            'users_all' => $users_all,
            'total_deliveries' => $total_deliveries
        ]);
     }
    }



    public function getDeliveryReportDating(Request $request)
    {   
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_branch = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
        $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

            $unconfirmed = \DB::table('orders')
                ->where('status', 0)
                ->orWhere('dispatch_status', 0)
                ->whereDate('created_at', $from)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                        
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $unconfirmed = 0;

            $branch_total_general = $confirmed - $discounts;
        }elseif ($request->category == "Drive Thru") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $unconfirmed = 0;

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->whereDate('orders.created_at',  $from)
        ->get();
        


        return view('sales.sales-person-category-with-item', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }else {
        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

                $unconfirmed = \DB::table('orders')
                ->where('status', 0)
                ->orWhere('dispatch_status', 0)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->whereBetween('orders.created_at',   [$from, $to])
        ->get();
        

        return view('sales.sales-person-category-with-item', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }

    }




    public function getDeliveryReport(Request $request)
    {   
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

        if ($from == $to) {
        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->whereDate('created_at', $from)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->whereDate('created_at', $from)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
        $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');


        $unconfirmed = \DB::table('orders')
                ->where('status', 1)
                ->where('dispatch_status', 0)
                ->whereDate('created_at', $from)
                ->where('category',  $request->category)
                ->where('branch', $request->branch)
                ->sum('total_cost_order');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;

            $unconfirmed = 0;
        }else{
            $confirmed = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('branch', $request->branch)
            ->whereDate('created_at', $from)
            ->where('invoice_sales_person_category', $request->category)
            ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;

            $unconfirmed = 0;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->whereDate('created_at', $from)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->whereDate('created_at', $from)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->whereDate('orders.created_at',  $from)
        ->get();
        


        return view('sales.sales-person-category', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'unconfirmed' => $unconfirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }else {
        $sales_today_branch = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        $rejected = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
        
        $onthehouse = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->where('branch', $request->branch)
            ->where('invoice_sales_person_category', $request->category)
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->sum('invoice_total_price');

        $discounts = \DB::table('discounts')
            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
            ->where('branch', $request->branch)
            ->where('category', $request->category)
            ->sum('amount_deducted');

        $deliveriestoday = \DB::table('invoices')
        ->where('invoice_status', 1)
        ->where('invoice_category', "TRANSPORT")
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->sum('invoice_total_price');
    


        if ($request->category == "Delivery") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');
                    
        $branch_total_general = $confirmed - ($discounts);
        }elseif ($request->category == "Counter") {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }else {
            $confirmed = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('branch', $request->branch)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');

            $branch_total_general = $confirmed - $discounts;
        }

        // On the House
        $branch_total_house = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_house_list = \DB::table('invoices')
        ->where('invoice_status', 2)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

        // Rejected Orders
        $branch_total_reject = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $branch_total_reject_list = \DB::table('invoices')
        ->where('invoice_status', 0)
        ->where('invoice_sales_person_category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();

       $order =  \DB::table('orders')
        ->where('category', $request->category)
        ->where('branch', $request->branch)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->get();


        $orders =  \DB::table('invoices')
        ->where('branch', $request->branch)
        ->where('invoice_sales_person_category', $request->category)
        ->where('invoice_status', 1)
        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
        ->sum('invoice_total_price');

        $orderDiscounted =  \DB::table('orders')
        ->join('discounts', 'orders.id','discounts.order_number')
        ->where('discounts.branch', $request->branch)
        ->where('orders.category', $request->category)
        ->whereBetween('orders.created_at',   [$from, $to])
        ->get();
        

        return view('sales.sales-person-category', [
            'sales_today_branch' => $sales_today_branch,
            'branch_total_general' => $branch_total_general,
            'branch_total_house' => $branch_total_house,
            'branch_total_reject' => $branch_total_reject,
            'branch_total_reject_list' => $branch_total_reject_list,
            'branch_total_house_list' => $branch_total_house_list,
            'order' => $order,
            'deliveriesToday' => $deliveriestoday,
            'orders' => $orders,
            'discounts' => $discounts,
            'confirmed' => $confirmed,
            'discounted_coupon' => $orderDiscounted
        ]);

    }

    }



    public function dateReportByCashier(Request $request)
    {
            $value = explode(' - ', $request->date);

            $source1 = $value[0];
            $date1 = new DateTime($source1);
            $from = $date1->format('Y-m-d');
        
            $source2 = $value[1];
            $date2 = new DateTime($source2);
            $to = $date2->format('Y-m-d');

            $user_data = User::findOrfail($request->user_id);
        
            if ($from == $to) {
            // total Earnings With Delivery Cost
            $totalearning = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('payment_status', 1)
            ->where('payment_accepted_by', $user_data->id)
            ->where('branch', $user_data->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');
        
            $deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_category', "TRANSPORT")
            ->where('invoice_sales_person_category', "Delivery")
            ->where('payment_status', 1)
            ->where('payment_accepted_by', $user_data->id)
            ->where('branch', $user_data->branch)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');
        
            $discount_money = \DB::table('orders')
            ->where('payment_accepted_by', $user_data->id)
            ->where('payment_status', 1)
            ->where('branch', $user_data->branch)
            ->whereDate('created_at', $from)
            ->sum('discount');
        
            // total Earnings Without Delivery Cost
            $total_no_delivery = $totalearning - ($deliveries + $discount_money);
        
        
            // total Earnings Delivery Amount
            $total_actual_delivery = $deliveries;
        
        
        
            // completed Deliveries
            $completed_deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('payment_status', 1)
            ->where('payment_accepted_by', $user_data->id)
            ->where('branch', $user_data->branch)
            ->whereDate('created_at', $from)
            ->get();
        
        
            // CASH Receivables
            $cash = \DB::table('dispatches')
            ->where('dispatch_status', 1)
            ->where('dispatch_branch', $user_data->branch)
            ->where('momo',"CASH")
            ->whereDate('created_at', $from)
            ->sum('amount');
        
        
            //  riders
            $riders = \DB::table('riders')
            ->where('branch',$user_data->branch)
            ->get();
        
        
            $momo = \DB::table('dispatches')
            ->where('dispatch_status', 1)
            ->where('dispatch_branch', $user_data->branch)
            ->where('momo',"MOMO")
            ->whereDate('created_at', $from)
            ->sum('amount');
        
        
        
            $sales_p = \DB::table('users')
            ->where('role', "Sales Person")
            ->where('branch', $user_data->branch)
            ->get();
        
            return view('cashier.cashier-report', [
            'with_delivery' => $totalearning, 
            'total_no_delivery' => $total_no_delivery,
            'total_actual_delivery' => $total_actual_delivery,
            'completed_deliveries' => $completed_deliveries,
            'cash' => $cash,
            'momo' => $momo,
            'riders_' => $riders,
            'sales_p'=> $sales_p,
            'discount_money' =>  $discount_money,
            'all_customers' => \DB::table('customers')->get(),
            'from' => $from,
            'to' => $to
        
            ]);
            }else {
            // total Earnings With Delivery Cost
            $totalearning = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('payment_status', 1)
            ->where('payment_accepted_by', $user_data->id)
            ->where('branch', $user_data->branch)
            ->whereBetween('created_at', [$from, $to])
            ->sum('invoice_total_price');
        
            $deliveries =  \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', "Delivery")
            ->where('invoice_category', "TRANSPORT")
            ->where('branch', $user_data->branch)
            ->whereBetween('created_at', [$from, $to])
            ->sum('invoice_total_price');
        
        
            $discount_money = \DB::table('orders')
            ->where('payment_accepted_by', $user_data->id)
            ->where('payment_status', 1)
            ->where('branch', $user_data->branch)
            ->whereDate('created_at', [$from, $to])
            ->sum('discount');
        
            // total Earnings Without Delivery Cost
            $total_no_delivery = $totalearning - $deliveries;
        
        
            // total Earnings Delivery Amount
            $total_actual_delivery = $deliveries;
        
        
        
            // completed Deliveries
            $completed_deliveries = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('payment_status', 1)
                ->where('payment_accepted_by', $user_data->id)
                ->where('branch', $user_data->branch)
                ->whereBetween('created_at', [$from, $to])
                ->get();
        
        
        
            // CASH Receivables
            $cash = \DB::table('dispatches')
            ->where('dispatch_status', 1)
            ->where('dispatch_branch', $user_data->branch)
            ->where('momo',"CASH")
            ->whereBetween('created_at', [$from, $to])
            ->sum('amount');
        
        
            //  riders
            $riders = \DB::table('riders')
            ->where('branch',$user_data->branch)
            ->get();
        
        
            $momo = \DB::table('dispatches')
            ->where('dispatch_status', 1)
            ->where('dispatch_branch', $user_data->branch)
            ->where('momo',"MOMO")
            ->whereBetween('created_at', [$from, $to])
            ->sum('amount');
        
        
        
            $sales_p = \DB::table('users')
            ->where('role', "Sales Person")
            ->where('branch', $user_data->branch)
            ->get();
        
            return view('cashier.cashier-report', [
                'with_delivery' => $totalearning, 
                'total_no_delivery' => $total_no_delivery,
                'total_actual_delivery' => $total_actual_delivery,
                'completed_deliveries' => $completed_deliveries,
                'cash' => $cash,
                'momo' => $momo,
                'riders_' => $riders,
                'sales_p'=> $sales_p,
                'discount_money' =>  $discount_money,
                'all_customers' => \DB::table('customers')->get(),
                'from' => $from,
                'to' => $to
        
            ]);
        }
    }





    public function getDeliveryReportDate(Request $request)
    {
        
        $value = explode(' - ', $request->date);
         
        $source1 = $value[0];
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        $source2 = $value[1];
        $date2 = new DateTime($source2);
        $to = $date2->format('Y-m-d');

    if ($from == $to) {
        if ($request->category == "Delivery") {
            $ordersum = \DB::table('invoices')
            ->where('invoice_status', 1)
            ->where('invoice_sales_person_category', $request->category)
            ->whereDate('created_at', $from)
            ->sum('invoice_total_price');
                
            }elseif ($request->category == "Counter") {
                $ordersum = \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('invoice_sales_person_category', $request->category)
                    ->whereDate('created_at', $from)
                    ->sum('invoice_total_price');
            }

            $discounts = \DB::table('discounts')
                ->whereDate('created_at', $from)
                ->where('category', $request->category)
                ->sum('amount_deducted');

            $sales_today_branch = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

                    // On the House
            $branch_total_house = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');

            $branch_total_house_list = \DB::table('invoices')
                ->where('invoice_status', 2)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

            // Rejected Orders
            $branch_total_reject = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->sum('invoice_total_price');

            $branch_total_reject_list = \DB::table('invoices')
                ->where('invoice_status', 0)
                ->where('invoice_sales_person_category', $request->category)
                ->whereDate('created_at', $from)
                ->get();

            $order =  \DB::table('orders')
                ->select('*')
                ->where('category', $request->category)
                ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                ->get();

            $deliveriestoday = \DB::table('invoices')
                ->where('invoice_status', 1)
                ->where('invoice_category', "TRANSPORT")
                ->whereDate('created_at', $from)
                ->where('invoice_sales_person_category', $request->category)
                ->sum('invoice_total_price');


            $branch_total_general = $ordersum - $discounts;

            return view('sales.sales-person-category-bydate', [
                'sales_today_branch' => $sales_today_branch,
                'branch_total_general' => $branch_total_general,
                'branch_total_house' => $branch_total_house,
                'branch_total_reject' => $branch_total_reject,
                'branch_total_reject_list' => $branch_total_reject_list,
                'branch_total_house_list' => $branch_total_house_list,
                'order' => $order,
                'deliveriesToday' => $deliveriestoday,
                'discounts' => $discounts
            ]);

        }else {
            if ($request->category == "Delivery") {
                if ($request->category == "Delivery") {
                    $ordersum = \DB::table('invoices')
                    ->where('invoice_status', 1)
                    ->where('invoice_sales_person_category', $request->category)
                    ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                    ->sum('invoice_total_price');
                        
                    }elseif ($request->category == "Counter") {
                        $ordersum = \DB::table('invoices')
                            ->where('invoice_status', 1)
                            ->where('invoice_sales_person_category', $request->category)
                            ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                            ->sum('invoice_total_price');
                    }
        
                    $discounts = \DB::table('discounts')
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->where('category', $request->category)
                        ->sum('amount_deducted');
        
                    $sales_today_branch = \DB::table('invoices')
                        ->where('invoice_status', 1)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                            // On the House
                    $branch_total_house = \DB::table('invoices')
                        ->where('invoice_status', 2)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->sum('invoice_total_price');
        
                    $branch_total_house_list = \DB::table('invoices')
                        ->where('invoice_status', 2)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    // Rejected Orders
                    $branch_total_reject = \DB::table('invoices')
                        ->where('invoice_status', 0)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->sum('invoice_total_price');
        
                    $branch_total_reject_list = \DB::table('invoices')
                        ->where('invoice_status', 0)
                        ->where('invoice_sales_person_category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    $order =  \DB::table('orders')
                        ->select('*')
                        ->where('category', $request->category)
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->get();
        
                    $deliveriestoday = \DB::table('invoices')
                        ->where('invoice_status', 1)
                        ->where('invoice_category', "TRANSPORT")
                        ->WhereDate('created_at','>=', $from)
            ->WhereDate('created_at','<=', $to)
                        ->where('invoice_sales_person_category', $request->category)
                        ->sum('invoice_total_price');
        
        
                    $branch_total_general = $ordersum - $discounts;
        
                    return view('sales.sales-person-category-bydate', [
                        'sales_today_branch' => $sales_today_branch,
                        'branch_total_general' => $branch_total_general,
                        'branch_total_house' => $branch_total_house,
                        'branch_total_reject' => $branch_total_reject,
                        'branch_total_reject_list' => $branch_total_reject_list,
                        'branch_total_house_list' => $branch_total_house_list,
                        'order' => $order,
                        'deliveriesToday' => $deliveriestoday,
                        'discounts' => $discounts
                    ]);
        
            }

        }
    }


    public function salesTodayBySalesPerson()
    {   
        // getDay close
        $getDayClose = \DB::table('close_days')->first();
        
        if (auth()->user()->role == "Dispatch Manager") {
           abort(403,"Unanthorized User");
        }else {
            if (auth()->user()->sales_person_category == "Delivery"){
               $deliveriestoday = \DB::table('invoices')
               ->where('user_id', auth()->user()->id)
               ->where('invoice_status', 1)
               ->where('invoice_category', "TRANSPORT")
               ->whereDate('created_at', $getDayClose->day_close)
               ->sum('invoice_total_price');
               
                // general
                $sales_today_branch = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();
                $sales_today_branch = $sales_today_branch->sortByDesc('created_at');

                // general
                $sales_today_branch_all = \DB::table('orders')
                ->where('user_id', auth()->user()->id)
                ->where('status', 1)
                ->where('dispatch_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('total_cost_order');
                
                // On the House
                $branch_total_house_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_house_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();

                // Rejected Orders
                $branch_total_reject_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_reject_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();


                $orderDiscounted =  \DB::table('orders')
                ->join('discounts', 'orders.id','discounts.order_number')
                ->where('orders.user_id', auth()->user()->id)
                ->whereDate('orders.created_at', $getDayClose->day_close)
                ->get();

                $discounts = \DB::table('discounts')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('amount_deducted');

                $orders = \DB::table('invoices')
                    ->where('user_id', auth()->user()->id)
                    ->where('invoice_status', 1)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('invoice_total_price');


                $order =  \DB::table('orders')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();

               $branch_total_general = $sales_today_branch_all-($discounts);
               $user_details = User::findOrfail(auth()->user()->id);

               return view('sales.view-user-sale', [
                'sales_today_branch' => $sales_today_branch,
                'user_data' => $user_details,
                'branch_total_general' => $branch_total_general,
                'branch_total_house_sum' => $branch_total_house_sum,
                'branch_total_reject_sum' => $branch_total_reject_sum,
                'branch_total_reject_list' => $branch_total_reject_list,
                'branch_total_house_list' => $branch_total_house_list,
                'order' => $order,
                'orders' => $orders,
                'discounts' => $discounts,
                'discounted_coupon' => $orderDiscounted,
                'deliveriesToday' => $deliveriestoday
            ]);


            }elseif (auth()->user()->sales_person_category == "Counter") {
                // general
                $sales_today_branch = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();
                $sales_today_branch = $sales_today_branch->sortByDesc('created_at');

                // general
                $sales_today_branch_all = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');
                
                // On the House
                $branch_total_house_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_house_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();

                // Rejected Orders
                $branch_total_reject_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_reject_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();


                $orderDiscounted =  \DB::table('orders')
                ->join('discounts', 'orders.id','discounts.order_number')
                ->where('orders.user_id', auth()->user()->id)
                ->whereDate('orders.created_at', $getDayClose->day_close)
                ->get();

                $discounts = \DB::table('discounts')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('amount_deducted');

                $orders = \DB::table('invoices')
                    ->where('user_id', auth()->user()->id)
                    ->where('invoice_status', 1)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('invoice_total_price');


                $order =  \DB::table('orders')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();

               $branch_total_general = $sales_today_branch_all-($discounts);
               $user_details = User::findOrfail(auth()->user()->id);

               return view('sales.view-user-sale', [
                'sales_today_branch' => $sales_today_branch,
                'user_data' => $user_details,
                'branch_total_general' => $branch_total_general,
                'branch_total_house_sum' => $branch_total_house_sum,
                'branch_total_reject_sum' => $branch_total_reject_sum,
                'branch_total_reject_list' => $branch_total_reject_list,
                'branch_total_house_list' => $branch_total_house_list,
                'order' => $order,
                'orders' => $orders,
                'discounts' => $discounts,
                'discounted_coupon' => $orderDiscounted
            ]);


            }
            elseif (auth()->user()->sales_person_category == "Drive Thru") {
                // general
                $sales_today_branch = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();
                $sales_today_branch = $sales_today_branch->sortByDesc('created_at');

                // general
                $sales_today_branch_all = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 1)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');
                
                // On the House
                $branch_total_house_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_house_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 2)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();

                // Rejected Orders
                $branch_total_reject_sum = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->sum('invoice_total_price');

                $branch_total_reject_list = \DB::table('invoices')
                ->where('user_id', auth()->user()->id)
                ->where('invoice_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->get();


                $orderDiscounted =  \DB::table('orders')
                ->join('discounts', 'orders.id','discounts.order_number')
                ->where('orders.user_id', auth()->user()->id)
                ->whereDate('orders.created_at', $getDayClose->day_close)
                ->get();

                $discounts = \DB::table('discounts')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('amount_deducted');

                $orders = \DB::table('invoices')
                    ->where('user_id', auth()->user()->id)
                    ->where('invoice_status', 1)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->sum('invoice_total_price');


                $order =  \DB::table('orders')
                    ->where('user_id', auth()->user()->id)
                    ->whereDate('created_at', $getDayClose->day_close)
                    ->get();

               $branch_total_general = $sales_today_branch_all-($discounts);
               $user_details = User::findOrfail(auth()->user()->id);

               return view('sales.view-user-sale', [
                'sales_today_branch' => $sales_today_branch,
                'user_data' => $user_details,
                'branch_total_general' => $branch_total_general,
                'branch_total_house_sum' => $branch_total_house_sum,
                'branch_total_reject_sum' => $branch_total_reject_sum,
                'branch_total_reject_list' => $branch_total_reject_list,
                'branch_total_house_list' => $branch_total_house_list,
                'order' => $order,
                'orders' => $orders,
                'discounts' => $discounts,
                'discounted_coupon' => $orderDiscounted
            ]);
            }
            
        }

        
    }

}
