<?php

namespace App\Http\Controllers;

use App\Models\TargetAnalysis;
use Illuminate\Http\Request;
use DateTime;

class TargetAnalysisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TargetAnalysis  $targetAnalysis
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $source1 = $request->date;
        $date1 = new DateTime($source1);
        $from = $date1->format('Y-m-d');

        if ($request->target_month == "") {
            if ($request->branch == "ALL BRANCHES") {
                    $summary = \DB::table('target_analyses')
                    ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                    ->groupBy('branch')
                    ->groupBy('daily_target')
                    ->whereDate('created_at',  $from)
                    ->get();

                    // $allbranchTarget =\DB::table('target_analyses')
                    // ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                    // ->groupBy('branch')
                    // ->groupBy('daily_target')
                    // ->whereDate('created_at',  $from)
                    // ->sum('daily_target');
            }else {
                    $summary = \DB::table('target_analyses')
                    ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                    ->groupBy('branch')
                    ->groupBy('daily_target')
                    ->where('branch', $request->branch)
                    ->whereDate('created_at',  $from)
                    ->get();
        
                    // $allbranchTarget ==\DB::table('target_analyses')
                    // ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                    // ->groupBy('branch')
                    // ->groupBy('daily_target')
                    // ->whereDate('created_at',  $from)
                    // ->where('branch', $request->branch)
                    // ->sum('daily_target');
            }
        }else {
            if ($request->branch == "ALL BRANCHES") {
                $summary = \DB::table('target_analyses')
                ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                ->groupBy('branch')
                ->groupBy('daily_target')
                ->whereMonth('created_at',  explode(' - ', $request->target_month)[0])
                ->whereYear('created_at',  explode(' - ', $request->target_month)[1])
                ->get();

                // $allbranchTarget =\DB::table('target_analyses')
                // ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                // ->groupBy('branch')
                // ->groupBy('daily_target')
                // ->whereMonth('created_at',  explode(' - ', $request->target_month)[0])
                // ->whereYear('created_at',  explode(' - ', $request->target_month)[1])
                // ->sum('daily_target');
        }else {
                $summary = \DB::table('target_analyses')
                ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                ->groupBy('branch')
                ->groupBy('daily_target')
                ->where('branch', $request->branch)
                ->whereMonth('created_at',  explode(' - ', $request->target_month)[0])
                ->whereYear('created_at',  explode(' - ', $request->target_month)[1])
                ->get();
    
                // $allbranchTarget ==\DB::table('target_analyses')
                // ->selectRaw('branch as branch, daily_target as daily_target, sum(total_cost) as sales')
                // ->groupBy('branch')
                // ->groupBy('daily_target')
                // ->where('branch', $request->branch)
                // ->whereMonth('created_at',  explode(' - ', $request->target_month)[0])
                // ->whereYear('created_at',  explode(' - ', $request->target_month)[1])
                // ->sum('daily_target');
        }

        return view('target-summary-month', [
                'summary'=>$summary,
                // 'allbranchTarget' => $allbranchTarget,
        ]);
    }
        

            return view('target-summary', [
                    'summary'=>$summary,
                    // 'allbranchTarget' => $allbranchTarget,
            ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TargetAnalysis  $targetAnalysis
     * @return \Illuminate\Http\Response
     */
    public function edit(TargetAnalysis $targetAnalysis)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TargetAnalysis  $targetAnalysis
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TargetAnalysis $targetAnalysis)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TargetAnalysis  $targetAnalysis
     * @return \Illuminate\Http\Response
     */
    public function destroy(TargetAnalysis $targetAnalysis)
    {
        //
    }
}
