<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Cache;
use Illuminate\Support\Facades\Http;


class UserController extends Controller
{      
    public function __construct()
    {
        $this->middleware('auth');
    }



    public function changePassword(Request $request, $id)
    {   
        
        $user = User::findOrfail($id);
        $this->validate($request, [
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        if (Hash::check($request -> old_password, $user -> password)) {
            $user -> password = Hash::make($request -> password);
            $user -> save();
            return back()->with('status', 'Password Changed Successfully');
           }else {
            return back()->with('statuspass', 'Password Does not Match existing password');
        }
    }

    public function update(User $user, Request $request)
    {
        $user->email = $request->useremail;
        $user->save();
        return back()->with('status', 'User Information Updated Successfully');
    }


    public function create(Request $request)
    {
        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'branch' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'sales_person_category' => ['required', 'string', 'max:255'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);


        User::create([
            'name' => $request->name,
            'email' => $request->email,
            'branch' => $request->branch,
            'role' => $request->role,
            'sales_person_category' => $request->sales_person_category,
            'password' => Hash::make($request->password),
        ]);

        return 123;
    }


    public function allUSers()
    {   

        $this->authorize('create', App\Models\User::class);

        if (auth()->user()->role == "Branch Officer") {
           abort(403, "UNAUTHORIZED USER");
        }
        $admin = User::where('role','Administrator')->get();
        $allusers = User::where('role','!=','Administrator')->get();
        return view('user', [
           'allusers' => $allusers,
           'admins'=> $admin
        ]);
    }


    public function inventory()
    {
        $response = Http::asForm()->post('http://inventory.sys/api/login/from-pos', [
            'email' => auth()->user()->email,
            'role' => auth()->user()->role,
        ]);
        return $response;
    }


    public function destroy(User $user)
    {
        $user->delete();
        return 123;
    }


    public function edit(User $user)
    {   
        $this->authorize('viewAny', App\Models\User::class);
        $assigned_branches = \DB::table('user_multiple_branch')->where('user_id', $user->id)->first();
        return view('users-profile',[
        'userprofile' => $user,
        'assigned_branches' => empty($assigned_branches->branches) ? "NO BRANCH ASSIGNED" : $assigned_branches->branches
        ]);
    }


    public function updateUserProfile(Request $request, User $user)
    {   

        $this->validate($request, [
            'name' => ['required', 'string', 'max:255'],
            'branch' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'sales_person_category' => ['required', 'string', 'max:255'],
        ]);

        $user->name = $request->name;
        $user->email = $request->email;
        $user->branch = $request->branch;
        $user->role = $request->role;
        $user->sales_person_category = $request->sales_person_category;
        $user->save();


        $multiple_branch = \DB::table('user_multiple_branch')->where('user_id', $user->id)->first();

        if (empty($multiple_branch)) {
            \DB::table('user_multiple_branch')->insert([
                'user_id' => $user->id,
                'branches' => implode( ",", $request->assigned)
            ]);
        }else {
            \DB::table('user_multiple_branch')->where('user_id', $user->id)->update([
                'user_id' => $user->id,
                'branches' =>implode( ",", $request->assigned)
            ]);
        }
        return back()->with('status', 'User Information Updated Successfully');
    }
   

    public function AssignStore(Request $request, User $user)
    {
        $this->validate($request, [
            'station' => ['required', 'string', 'max:255'],
        ]);
        $user->station = $request->station;
        $user->save();
        return back()->with('status', 'User Assigned to a station at the Back office');

    }


    public function changePasswordUser(Request $request, User $user)
    {
        $this->validate($request, [
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        $user -> password = Hash::make($request -> password);
        $user -> save();
        return back()->with('status', 'Password Changed Successfully');

    }
}

