<?php

namespace App\Http\Controllers;

use App\Models\WebsiteReview;
use Illuminate\Http\Request;
use Carbon\carbon;
use DateTime;

class WebsiteReviewController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $this->authorize('viewAny', App\Models\User::class);
        return view('website-review', [
            'reviews_today' => \DB::table('website_reviews')->where('customer_name','!=', null)->whereDate('created_at', carbon::today())->get()
        ]);
    }

    public function ReviewByDate(Request $request)
    {
        $this->authorize('viewAny', App\Models\User::class);


            $value = explode(' - ', $request->date);
            

            $source1 = $value[0];
            $date1 = new DateTime($source1);
            $from = $date1->format('Y-m-d');

            $source2 = $value[1];
            $date2 = new DateTime($source2);
            $to = $date2->format('Y-m-d');

            if ($from == $to) {
            return view('website-review', [
                'reviews_today' => \DB::table('website_reviews')->where('customer_name','!=', null)->whereDate('created_at', $from)->get()
            ]);
        }else {
            return view('website-review', [
                'reviews_today' => \DB::table('website_reviews')->where('customer_name','!=', null)
                ->WhereDate('created_at','>=', $from)
                ->WhereDate('created_at','<=', $to)
                ->get()
            ]);
        }
    }

}
