<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Auth;
use View;
use DB;
use Blade;
use App\Models\invoice;
use Carbon\carbon;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {   
        Paginator::useBootstrap();
        View::composer('*', function($view){
            $getDayClose = \DB::table('close_days')->first();

            $satellite_kitchen = \DB::table('kitchens')->where('kitchen_category', "S")->get();
            $view->with('satellite_kitchen', $satellite_kitchen);

            $kitchens = \DB::table('kitchens')->get();
            $view->with('kitchens', $kitchens);

            $warehouses = \DB::table('warehouses')->get();
            $view->with('warehouses', $warehouses);

            $brands = \DB::table('brands')->get();
            $view->with('brands', $brands);

            $all_branches = \DB::table('branches')->orderBy('branch_name', "ASC")->get();
            $view->with('all_branch', $all_branches->pluck('branch_name'));
            $view->with('all_branch_', $all_branches);


            $all_rawmaterial = \DB::table('raw_materials')->get();
            $view->with('all_rawmaterial', $all_rawmaterial);


            $riders = \DB::table('riders')->get();
            $view->with('riders', $riders);


            $app = \DB::table('settings')->first();
            $view->with('app', $app);

            $currencies = \DB::table('currencies')->get();
            $view->with('currencies', $currencies);



            $trending = \DB::table('final_productions')->where('production_category', "PIZZAMAN")->paginate(4);
            $view->with('trending', $trending);

            $darkmode = \DB::table('darkmodes')->first();
            $view->with('darkmode', $darkmode->state);

            
            if (Auth::check()) {
                $all_location = \DB::table('dispatch_items')->where('location_branch', auth()->user()->branch)->get();
                $view->with('location',$all_location);

                $assigned_branches = \DB::table('user_multiple_branch')->where('user_id', auth()->id())->first();
                
                if (empty($assigned_branches-> branches)) {
                    $assigned_branches = [];
                }else {
                    $assigned_branches = explode(",", $assigned_branches-> branches);
                }

                $view->with('multi_branch', $assigned_branches);

                $pendingCount = \DB::table('online_customers')
                        ->where('order_state', 2)
                        ->where('orders','!=', null)
                        ->whereDate('date', $getDayClose->day_close)
                        ->where('order_branch', auth()->user()->branch)
                        ->get();
                        $view->with('pendingCount', $pendingCount);

                $pending_orders_agency = \DB::table('online_customers')
                ->where('order_state', 2)
                ->whereDate('date', $getDayClose->day_close)
                ->where('agency_orders','!=', null)
                ->where('agency','!=', null)
                ->where('order_branch', auth()->user()->branch)
                ->count();
                $view->with('agencycount', $pending_orders_agency);

               \DB::table('branches')->get();

               $confirmIfBar = \DB::table('branches')->where('branch_name', auth()->user()->branch)->first();
               $view->with('bar', $confirmIfBar->store_type);
                

                $deliveryOrders = \DB::table('invoices')
                ->where('invoice_sales_person_category', "Delivery")
                ->where('branch', auth()->user()->branch)
                ->where('agency', Null)
                ->where('drive_thru_status', 0)
                ->whereDate('created_at', $getDayClose->day_close)
                ->orderBy('created_at', 'ASC')
                ->get();
                $grouped = $deliveryOrders->groupBy('invoice_number');

                $view->with('deliveryOrders', $grouped->count());
            }

            // $customers= \DB::table('customers')
            // ->get();
            // $view->with('all_customers', $customers);


            $orders = \DB::table('orders')
            ->whereDate('created_at', Carbon::today())
            ->where('status', 0)
            ->get();
            $view->with('orders_pending', $orders);


            Blade::directive('convert', function ($money) {
                return "<?php echo number_format($money, 2); ?>";
            });

            $h_person = \DB::table('house_people')->get();
            $view->with('house_person', $h_person);

            $sales_month = \DB::table('invoices')
            ->where('invoices.created_at', '>=', Carbon::now()->subDays(30))
            ->sum('invoice_total_price');
            $view->with('sales_month', $sales_month);


            $agency = \DB::table('agencies')->get();
            $view->with('agency', $agency);
            $view->with('agencies', $agency);

            $kitchens = \DB::table('kitchens')->get();
            $view->with('kitchens', $kitchens);


            $warehouses = \DB::table('warehouses')->get();
            $view->with('warehouses', $warehouses);


            // GET DAY CLOSE DATE
            $getDayClose = \DB::table('close_days')->first();
            $view->with('getDayClose', $getDayClose);


            // Target Month
            $targets = \DB::table('month_targets')->get();
            $view->with('targets', $targets);


            // users
            $allUsers = \DB::table('users')->get();
            $view->with('all_users', $allUsers);


            $sum = 0;
            $checkseesion = session()->get('cart');
            $view->with('cartItems', session()->get('cart'));
            $view->with('checkseesion', $checkseesion);
                if (!empty($checkseesion) || null) {
                    foreach ($checkseesion as $item) {
                    $result = (float)$item['invoice_quantity'] * (float)$item['invoice_unit_price'];
                    $sum+=$result;
                    }
                    $view->with('totalCart', $sum);
                }


            $pizzaman_remark = ["SATISFIED","SALTY PIZZA","OILY PIZZA","LESS TOPPINGS","SPICY PIZZA","DRY
            PIZZA","SWEET AND SUGARY PIZZA","LESS CHEESE","TOO CHEESY","FLAT OR LIGHT PIZZA
            CRUST","SMALL SIZED PIZZA","INCONSISTENT TASTE","NO VEGGIES","COLD PIZZA","BURNT
            PIZZA","UNDERCOOKED","WRONG ORDER","LATE PROCESSING ORDER","OTHER"];

            $view->with('pizzaman_remark', $pizzaman_remark);

            $chickenman_remark = ["SATISFIED","HARD CHICKEN","UNCOOKED CHICKEN","SPICY CHICKEN","PEPPERY
            CHICKEN","SMALL RICE QUANTITY","GREEN CHILLI","SPOILT CHICKEN","SPOILT RICE","OILY
            RICE","COLD RICE","HARD RICE","SMALL CHICKEN","SALTY CHICKEN","SALTY RICE","SOFT
            CHICKEN","SOFT RICE","SLIMY RICE","COLD FRIES","SALTY FRIES","SOGGY FRIES","LATE
            PROCESSING ORDER","OTHER","UNDERCOOKED","WRONG ORDER"];

            $view->with('chickenman_remark', $chickenman_remark);


            $dayClose = \DB::table('close_days')->first();
            $view->with('dayClose', $dayClose);

            $item_category = \DB::table('item_categories')->get();
            $view->with('item_category', $item_category);


            $nocharge = \DB::table('invoices')
            ->where('invoice_status', 2)
            ->whereDate('created_at',$dayClose->day_close)
            ->sum('invoice_total_price');
            $view->with('nocharge',  $nocharge);



            $rate =  [1,2,3,4,5,6,7,8,9,10];
            $view->with('rate', $rate);
            $view->with('rate1', $rate);
            $view->with('rate2', $rate);



            $mTax = \DB::table('taxes')->first();
            $gTax = $mTax->covid+$mTax->nhil+$mTax->getfund;
            $view->with('gTax', $gTax);
            $view->with('mTax', $mTax);


        });
    }
}
