<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->string('branch');
            $table->string('invoice_product_name');
            $table->string('invoice_status');
            $table->string('invoice_sales_person_category');
            $table->string('invoice_quantity');
            $table->string('invoice_unit_price');
            $table->string('invoice_total_price');
            $table->string('comment')->nullable();
            $table->string('invoice_category')->nullable();
            $table->string('invoice_number')->nullable();
            $table->timestamps();



            $table->foreign('user_id')
            ->references('id')
            ->on('users')
            ->onUpdate('cascade');


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
