<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDispatchesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dispatches', function (Blueprint $table) {
            $table->id();
            $table->unSignedBigInteger('rider_id');
            $table->unSignedBigInteger('order_number');
            $table->string('entered_by')->nullable();
            $table->string('momo');
            $table->string('amount');
            $table->string('deliveryamount');
            $table->string('dispatch_branch')->nullable();
            $table->string('status')->default(1)->nullable();
            $table->string('category')->nullable();
            $table->boolean('dispatch_status')->default(0)->nullable();
            $table->timestamps();


            $table->foreign('rider_id')
            ->references('id')
            ->on('riders');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dispatches');
    }
}
