<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDiscountsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discounts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('order_number')->nullable();
            $table->string('type');
            $table->unsignedBigInteger('order_id');
            $table->string('discount')->nullable();
            $table->string('category')->nullable();
            $table->string('branch')->nullable();
            $table->string('amount_paid')->nullable();
            $table->string('amount_deducted')->nullable();
            $table->timestamps();


            $table->foreign('user_id')
            ->references('id')
            ->on('users')
            ->onUpdate('cascade');

            $table->foreign('order_number')
            ->references('id')
            ->on('orders')
            ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('discounts');
    }
}
