@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Agencies</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <div class="table-responsive">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Agency Name</th>
                            <th>Agency Code</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($agencies as $agency)
                        <tr>
                        <td>{{$agency->agency_name}}</td>
                            <td>{{$agency->agency_description}}</td>
                            <td>{{$agency->agency_code}}</td>
                            <td>
                            <div class="actions">
                                <a href="#" data-bs-toggle="modal" data-bs-target="#editAgency{{$agency->id}}">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="#" data-toggle="tooltip" id="{{$agency->id}}" onclick="DeleteAgency(this.id)" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Agency</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form action="{{route('store.agency')}}" method="post">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="agency_name">
                                <div class="field-placeholder">Agency Name <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="description">
                                <div class="field-placeholder">Agency Description <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@foreach($agencies as $agency)
<!-- Modal start -->
<div class="modal fade" id="editAgency{{$agency->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">{{$agency->agency_name}}</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <form action="{{route('updateAgency',$agency->id)}}" method="post">
                @csrf
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <input class="form-control" required type="text" name="agency_name" value="{{$agency->agency_name}}">
                    <div class="field-placeholder">Agency Name <span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

            </div>

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <input class="form-control" required type="text" name="agency_code" value="{{$agency->agency_code}}">
                    <div class="field-placeholder">Agency Code <span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

            </div>

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <textarea name="description">{{$agency->agency_description}}</textarea>
                    <div class="field-placeholder">Agency Description <span class="text-danger">*</span></div>
                </div>
                <!-- Field wrapper end -->

            </div>

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <button class="btn btn-outline-primary" >Save Changes</button>
            </div>
        </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach


<script type="text/javascript">
    
    $("#branch").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.branch')}}",
                dataType: "json",
                data: $('#branch').serialize(),
                success: function(data){
                    $("#branch")[0].reset();
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New Branch Added Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function DeleteAgency(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    Swal.fire(
                        'Deleted!',
                        'Branch Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete/agency/"+id);
                xhttp.send();
            }
            })
            
        }
</script>


@endsection