@extends('layouts.auth-login')

@section('content')
	<!-- *************
			************ Login container start *************
		************* -->
		<div class="login-container">

			<div class="container-fluid h-100">
			
			<!-- Row start -->
			<div class="row no-gutters h-100">
				<div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
					<div class="login-about">
						<div class="slogan">
							<span>LOVE</span>
							<span>AT FIRST</span>
							<span>Bite.</span>
						</div>
						<div class="about-desc">
						We are mainly into the production and sales of variety of pizza and Chicken meals such as chicken wings, drumsticks, sauce, breast and khebab; accompanied with fried rice, jollof rice and french fries
						</div>
						<a href="https://www.ceqaltd.com" class="know-more">Know More <img src="img/right-arrow.svg" alt="Uni Pro Admin"></a>

					</div>
				</div>
				<div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
					<div class="login-wrapper">`
						@include('inc.errorfile')
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                    <div class="login-screen">
								<div class="login-body">
									<a href="#">
									<img src="/img/logo.png" alt="logo" style="max-width:120px;">
									</a>
									<h6>Welcome to PizzamanChickenMan,<br>Create your account.</h6>
									<div class="field-wrapper">
                                        <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <div class="field-placeholder">Full Name</div>
									</div>

                                    <div class="field-wrapper">
                                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <div class="field-placeholder">Email ID</div>
									</div>

									<div class="field-wrapper">
                                    <select class="form-control @error('role') is-invalid @enderror" name="role">
                                    	<option value="Sales Person">Sales Person</option>
                                    	<option value="Administrator">Administrator</option>
										<option value="Dispatch Manager">Dispatch Manager</option>
                                    </select>

                                        @error('role')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <div class="field-placeholder">Role</div>
									</div>

									<div class="field-wrapper">
                                    <select class="form-control @error('Branch') is-invalid @enderror" name="branch" required>
									<option value="KNUST BRANCH">KNUST BRANCH</option>
									    @foreach($all_branch as $branch)
										<option value="{{$branch}}">{{$branch}}</option>
										@endforeach
                                    </select>

                                        @error('branch')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <div class="field-placeholder">BRANCH OFFICE</div>
									</div>
                                    
									<div class="field-wrapper">
									<select class="form-control @error('Branch') is-invalid @enderror" name="sales_person_category" required>
									<option value="Counter">Counter</option>
									<option value="Delivery">Delivery</option>
                                    </select>

                                        @error('branch')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <div class="field-placeholder">SALES PERSON CATEGORY</div>
									</div>

									<div class="field-wrapper">
                                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
										<div class="field-placeholder">Password</div>
									</div>

									<div class="field-wrapper mb-3">
                                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
										<div class="field-placeholder">Confirm Password</div>
									</div>
									<div class="actions">
										<button type="submit" class="btn btn-primary ms-auto">Sign Up</button>
									</div>
								</div>
								<div class="login-footer">
									<span class="additional-link">Have an account? <a href="login.html" class="btn btn-light">Login</a></span>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- Row end -->

		
			</div>
		</div>
		<!-- *************
			************ Login container end *************
		************* -->


		<?php
			// 301 Moved Permanently
			header("Location: /home", true, 301);
			exit();
		?>
@endsection




