@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
            <div class="card-header-lg">
            <div class="card-title">
            <h5>Add Barcodes</h5>
            <p><small class="text-info">Assign barcodes to product for easy scanning</small></p>
            </div>
                @if(auth()->user()->role == "Administrator")
                <button class="btn btn-outline-primary rounded-pill" data-bs-toggle="modal" data-bs-target="#addNewDocument">Create Product</button>
                @endif
                <div class="modal fade" id="addNewDocument" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="addNewDocumentLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addNewDocumentLabel">Add New Product</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">

                            <form class="row gutters" method="post" action="{{route('loadProduct')}}" enctype="multipart/form-data">
                                @csrf
                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                
                                    <!-- Field wrapper start -->
                                    <div class="field-wrapper">
                                        <div class="input-group">														
                                            <input type="file" name="file" class="form-control" id="inputGroupFile01">
                                            <button class="btn btn-outline-primary" type="submit" required>Upload</button>
                                        </div>
                                        <div class="field-placeholder">Upload Products</div>
                                        <small class="text-primary"> <a href="/uploads/products.csv">Download Sample csv</a></small>
                                    </div>
                                    <!-- Field wrapper end -->
                                    

                                </div>
                            </form>
                            
                            <hr>
                            <div class="card-title">
                                Enter Item
                            </div>
                                <form class="row gutters" action="{{route('addProduct')}}" method="post" enctype="multipart/form-data">
                                    @csrf

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="file" class="form-control" name="image">
                                            <div class="field-placeholder">Product Image</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" name="p_name">
                                            <div class="field-placeholder">Product Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select  name="p_category" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                            <option selected disable>Select Category</option>
                                            @foreach($item_category as $category)
                                            <option>{{$category->category_name}}</option>
                                            @endforeach
                                            </select>
                                            <div class="field-placeholder">Category</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <select  name="p_brand" class="select-single js-states" title="Select Product Category" data-live-search="true">
                                            <option selected disable>Select Brand</option>
                                            @foreach($brands as $brand)
                                            <option>{{$brand->brand_name}}</option>
                                            @endforeach
                                            </select>
                                            <div class="field-placeholder">Brand</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="p_unit_price">
                                                <span class="input-group-text">
                                                {{empty($app->currency) ? "GHS" : $app->currency}}
                                                </span>
                                            </div>
                                            <div class="field-placeholder">Product Price</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="input-group">
                                                <input type="text" class="form-control" onKeydown="return event.key != 'Enter';" name="barcode" placeholder="Select Field and Scan">
                                                <span class="input-group-text">
                                                 <i class="icon-code2"></i>
                                                </span>
                                            </div>
                                            <div class="field-placeholder">Barcode</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper m-0">
                                            <textarea class="form-control" name="p_description" rows="3"></textarea>
                                            <div class="field-placeholder">Description</div>
                                        </div>
                                        <!-- Field wrapper end -->


                                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <span class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" id="checkSms3" value="1" name="store_category">
                                                <label class="form-check-label" for="checkSms3">Bar Menu Item</label>
                                            </span>

                                            <span class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" id="checkSms2" value="1" name="store_active">
                                                <label class="form-check-label" for="checkSms2">Active Online</label>
                                            </span>

                                        </div>


                                        </div>


                                        <div>
                                        <input type="text" class="form-control" name="product_code" hidden
                                                value="<?php echo "PD-".substr(str_shuffle("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 6) . date("hi"); ?>"
                                                >
                                        </div>
                                    </div>

                                   
                                 <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-outline-primary"> Continue</button>
                                    </div>
                                </form>
                                    </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>  
            
                <div class="card-body">
                <form action="{{route('ProductBarcodesSave')}}" method="post">
                    @csrf
                    <div class="table-responsive">
                    <table class="table table-bordered v-middle m-0">
                            <thead>
                                <tr>
                                  <th><input type="checkbox" id="select-all"></th>
                                  <th>Products</th>		
                                  <th>Barcode</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                    <td><input type="checkbox" name="product[]" value="{{$item->FinalProductionID}}"></td>
                                  <td>
                                  <div class="d-flex align-items-center">
                                        <div class="me-2">
                                            <img src="/uploads/{{empty($item->product_image) ? 'no-product.png' : $item->product_image}}" class="img-36" alt="Avatar">
                                        </div>
                                        <div >
                                            <b>{!!@strtoupper($item->Name)!!}</b>
                                            <div>
                                                <small class="text-muted">{{@strtoupper($item->product_code)}}</small>
                                            </div>
                                        </div>
                                    </div>
                                  </td>
                                  <td>
                                    <input type="text" name="items[<?=$item->FinalProductionID;?>][barcode]" onKeydown="return event.key != 'Enter';" class="form-control" value="{{$item->barcode}}" placeholder="eg...23467788, 2345677899, 3948575">
                                    <input type="text" name="items[<?=$item->FinalProductionID;?>][product_id]" class="form-control" value="{{$item->FinalProductionID}}" hidden>
                                  </td>	
                                  		
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mt-3">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
                
                </div>
                
        </div>
        
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script type="text/javascript">  
    document.getElementById('select-all').onclick = function(){
        var ele=document.getElementsByName('product[]');  
        for (var checkbox of ele) {
                checkbox.checked = this.checked;
            }
    
    }              
</script> 


@endsection