@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">

    </div>
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="card">
            <div class="card-header-lg">
            <h5>Report on Raw Materials - {{request()->branch}}, Date: {{request()->date}}</h5>
            <form action="{{route('RawMaterialBranchReport')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="branch" value="{{request()->branch}}" hidden>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn btn-primary"><i class="icon-download1"></i></button>
                    </div>
                </form>
            </div>  

            <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Item Name</th>
                                  <th>Quantity</th>
                                  <th>Total Used (Kg)/(PC)</th>													  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($comp as $item)
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{$item->name}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$item->quantity}}
                                  </td>
                                  <td>
                                  {{$item->total}}
                                  </td>											  
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->



</div>
<!-- Content wrapper end -->



@endsection