@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">OUTLETS</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Outlet Code</th>
                            <th>Outlet Name</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($branches as $branch)
                        <tr>
                        <td>{{$branch->branch_code}}</td>
                            <td>{{$branch->branch_name}} {!!$branch->store_type == 1 ? '<span class="badge bg-primary">' . "Bar" . '</span>' : '<span class="badge bg-info">' . "Main Store" . '</span>'!!}</td>
                            <td>{{$branch->branch_description}}</td>
                            <td>
                            <div class="actions">
                                <a href="{{route('EditBranch',$branch->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="#" data-toggle="tooltip" id="{{$branch->id}}" onclick="DeleteBranch(this.id)" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">NEW OUTLET</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form action="{{route('store.branch')}}" method="post" enctype="multipart/form-data">
                            @csrf

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="file" class="form-control" name="image">
                                <div class="field-placeholder">Outlet Image</div>
                            </div>
                            <!-- Field wrapper end -->
                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="branch_name">
                                <div class="field-placeholder">Outlet Name <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="branch_location">
                                <div class="field-placeholder">Outlet Location <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="branch_contact">
                                <div class="field-placeholder">Phone Number <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <input class="form-control" required type="text" name="branch_code">
                            <div class="field-placeholder">Outlet Code <span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="branch_momo">
                                <div class="field-placeholder">Outlet Momo Number <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <input class="form-control" required type="text" name="tingg_delivery">
                            <div class="field-placeholder">Tingg Delivery Code</div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="tingg_counter">
                                <div class="field-placeholder">Tingg Counter Code</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea class="form-control" rows="2" name="branch_description"></textarea>
                                <div class="field-placeholder">Description</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <!-- Field wrapper start -->
                        <div class="field-wrapper py-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="store_type" value="1" id="flexCheckChecked">
                                <label class="form-check-label" for="flexCheckChecked">
                                    Activate As Bar
                                </label>
                            </div>
                        </div>
                        <!-- Field wrapper end -->

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-light">Cancel</button>
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script type="text/javascript">
    
    $("#branch").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.branch')}}",
                dataType: "json",
                data: $('#branch').serialize(),
                success: function(data){
                    $("#branch")[0].reset();
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New Branch Added Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function DeleteBranch(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    Swal.fire(
                        'Deleted!',
                        'Branch Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-branch/"+id);
                xhttp.send();
            }
            })
            
        }
</script>


@endsection