@extends('layouts.app')

@section('content')
<!-- Content wrapper start -->
<div class="content-wrapper">


<!-- Breadcrumb container start -->
<div class="breadcrumb-container">

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item"><a href="/">Home</a></li>
              <li class="breadcrumb-item"><a href="{{route('brand.index')}}">Brands</a></li>
              <li class="breadcrumb-item active" aria-current="page">New Brand</li>
            </ol>
        </nav>
    </div>
</div>
<!-- Row end -->

</div>
<!-- Breadcrumb container end -->


<!-- Row start -->
<div class="row gutters">

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">New Brand</div>
            </div>
            <div class="card-body mt-4">
                
                <form class="needs-validation" novalidate method="POST" action="{{route('brand.create')}}">
                @csrf   
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="brand_name" required>
                                <div class="field-placeholder">Brand Name</div>
                                <div class="valid-feedback">Looks good!</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea name="brand_description" id="" cols="30" rows="10"></textarea>
                                <div class="field-placeholder">Description</div>
                                <div class="valid-feedback">Looks good!</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>

            </div>
        </div>
        <!-- Card end -->
    </div>

    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
        
        <!-- Card start -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Categories</div>
            </div>
            <div class="card-body mt-4">
                
            <div class="table-responsive">
                <table id="copy-print-csv" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Brand Name</th>
                        <th>Description</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($brands as $brand)
                        <tr>
                        <td>{{$brand->brand_name}}</td>
                        <td>{{$brand->brand_description}}</td>
                        <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit" data-bs-toggle="modal" data-bs-target="#brand<?=$brand->id?>">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                <a href="{{route('brand.destroy', $brand->id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
            </table>
            </div>

            </div>
        </div>
        <!-- Card end -->

    </div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->




@foreach($brands as $brand)
<!-- Modal start -->
<div class="modal fade" id="brand<?=$brand->id?>" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle"><strong>BRAND: </strong>{{@strtoupper($brand->brand_name)}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
           
            <form class="needs-validation" novalidate method="POST" action="{{route('brand.update', $brand->id)}}">
                @csrf   
                <!-- Row start -->
                    <div class="row gutters">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input type="text" class="form-control" name="brand_name" value="{{$brand->brand_name}}" required>
                                <div class="field-placeholder">Brand Name</div>
                                <div class="valid-feedback">Looks good!</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea name="brand_description" id="" cols="30" rows="10">{{$brand->brand_description}}</textarea>
                                <div class="field-placeholder">Description</div>
                                <div class="valid-feedback">Looks good!</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>
            
                        <div class="col-12">
                            <button class="btn btn-primary" type="submit">Save</button>
                        </div>
                    </div>
                    <!-- Row end -->
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach

@endsection