@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
    <div style="background-color:#ffffff; margin-bottom:13px; padding:10px">
    <h5>USER: {{$user_data->name}} -  Report of Accepted Payments for {{request()->date}}</h5>
    </div>
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-5 col-lg-5 col-md-6 col-sm-12 col-12">
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card h-475">
                        <div class="card-body pt-0">

                            <div class="earnings-detail">
                                <div class="earnings-info">
                                    <p class="text-lighter" style="margin-top:12px">Transaction for {{request()->date}}</p>
                                </div>
                            </div>

                            <!-- Row start -->
                            <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                    <thead>
                                        <tr>
                                            <th>Order Number</th>
                                            <th>Payment Type</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($completed_deliveries as $delivery)
                                        <tr>
                                            <td>
                                                <div class="media-box">
                                                    <div class="media-box-body text-truncate">
                                                        <a href="{{route('orderTransaction', $delivery -> invoice_number)}}">#{{$delivery->invoice_number}}</a>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{$delivery->invoice_product_name}}</td>
                                            <td>GH₵{{$delivery->invoice_total_price}}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            </div>
                            <!-- Row end -->
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/customer.svg" alt="Customers">
                        </div>
                        <div class="sale-details3">
                            <h3>{{$all_customers->count()}}</h3>
                            <p>New Customers</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/box.svg" alt="Customers">
                        </div>
                        <div class="sale-details3">
                            <h3>GH¢{{$with_delivery - $discount_money}}</h3>
                            <p>Total Transaction [Sales - (Deliveries+Discounts)]</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->
        </div>
        <div class="col-xl-7 col-lg-7 col-md-6 col-sm-12 col-12">								

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    
                    <div class="card h-475">
                   
                        <div style="padding:15px">
                       <h6> Sales Persons</h6><hr>
                        <div class="table-responsive">
                        <table id="hideSearchExample" class="table custom-table">
                                <thead>
                                    <tr>
                                    <th>Name </th>
                                    <th>Branch</th>
                                    <th>Category</th>
                                    <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_p as $person)
                                    <tr>
                                    <td>{{$person->name}}</td>
                                    <td>{{$person->branch}}</td>
                                    <td>{{$person->sales_person_category}}</td>
                                    <td>
                                    <form action="{{route('dateReportByUser')}}" method="GET">
                                                   <input type="text" readonly hidden name="date" value="{{request()->date}}">
                                                   <input type="text" readonly hidden name="user_id" value="{{$person->id}}">
                                                   <button class="btn btn-primary btn-sm"><i class="far fa-eye"></i></button>
                                               </form>
                                    </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                        </table>
                        </div>
                        </div>
                        <hr>
                        <div class="card-body pt-0">
                    
                            <div class="earnings-detail">
                                <div class="earnings-info">
                                    <p class="text-lighter">Completed Deliveries</p>
                                    <h5 class="text-danger">{{$completed_deliveries->count()}}</h5>
                                </div>
                                <button class="earnings-icon red">
                                    <i class="icon-download"></i>
                                </button>
                            </div>

                            <div class="table-responsive">
                                <table class="table products-table">
                                    <thead>
                                        <tr>
                                            <th>Rider Name</th>
                                            <th>Address</th>
                                            <th>Phone</th>
                                            <th>Transactions Today</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($riders_ as $rider)
                                        <tr>
                                            <td>
                                                <div class="media-box">
                                                    <div class="media-box-body text-truncate">
                                                        <a href="#">{{$rider->rd_name}}</a>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{$rider->rd_address}}</td>
                                            <td><span class="badge">{{$rider->rd_phone}}</span></td>
                                            <td>
                                               <form action="{{route('riderTransactions')}}" method="GET">
                                                   <input type="text" readonly hidden name="date" value="{{request()->date}}">
                                                   <input type="text" readonly hidden name="rider_id" value="{{$rider->id}}">
                                                   <button class="btn btn-primary"><i class="far fa-eye"></i></button>
                                               </form>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/income.svg" alt="Sales">
                        </div>
                        <div class="sale-details3">
                            <h3>GH¢@convert($total_no_delivery)</h3>
                            <p> Total Amount Accepted</p>
                        </div>
                        <div id="sparklineLine1" class="stats-graph3"></div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="stats-tile3">
                        <div class="sale-icon3">
                            <img src="/img/svg/commisions.svg" alt="Commisions">
                        </div>
                        <div class="sale-details3">
                            <h3>GH¢@convert($discount_money)</h3>
                            <p>Discounts</p>
                        </div>
                        <div id="sparklineLine2" class="stats-graph3"></div>
                    </div>
                </div>
            </div>
            <!-- Row end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection