@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Pending Payments</div>
                    <div style="float:right; margin:10px">
                    <a class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#exampleModalSmallreport" href="#"><i class="icon-report"></i> Report</a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dispatchorders as $order)
                        <tr>
                            <td>#{{$order->order_id}}
                                <br>
                                <?=  \Carbon\Carbon::parse($order->created_at)->diffForHumans() ?>
                            </td>
                            <td>
                            {!! $order->payment_status == 0 ? '<span class="badge rounded-pill bg-danger">' . "unpaid" . '</span>' : '<span class="badge rounded-pill bg-primary">' . "paid" . '</span>'!!}
                            </td>
                            <td>
                                {{$order->created_at}}
                            </td>
                            <td>
                            <a href="#" class="btn btn-outline-primary rounded-pill btn-sm" onclick="customer(this.id)" id="{{$order->customer_id}}"
                                data-bs-toggle="modal" data-bs-target="#exampleModalSmall">
                                <i class="icon-user-check"></i> View Customer
                            </a>
                             <!-- Modal start -->
                                <div class="modal fade" id="exampleModalSmall" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalSmallTitle">Customer Information</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div style="font-size:15px">
                                                <div id="name"></div>
                                                <div id="address"></div>
                                                <div id="phone"></div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @if($order->customer_id == null)
                            <a href="/ceqa-dashboard/print-invoice/{{$order->order_id}}" class="btn btn-outline-info rounded-pill btn-sm">
                             Accept Payment
                            </a>
                            @else
                            <a href="/ceqa-dashboard/print-invoice/delivery/{{$order->order_id}}/{{$order->customer_id}}" class="btn btn-outline-info rounded-pill btn-sm">
                             Accept Payment
                            </a>
                            @endif
                            
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="staticBackdropDispatch" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Process Order</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form action="{{route('processOrder')}}" method="post">
                @csrf
                <input type="text" hidden readonly name="order_number"  readonly id="order_number">
                <div class="form-group">
                    <label for="">Dispatch Rider Name</label>
                    <select name="rider_id" class="form-control">
                        <option selected disabled>Select Rider</option>
                        @foreach($riders_ as $rider)
                        <option value="{{$rider->id}}">{{$rider->rd_name}}</option>
                        @endforeach
                    </select>
                </div>


                <div class="form-group">
                    <label>Payment Option</label>
                    <select name="momo" required class="form-control">
                        <option value="CASH">CASH</option>
                        <option value="MOMO">MOMO</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="">Total Cost of Order</label>
                    <input name="amount" readonly required type="number" id="amount" step="0.01" class="form-control">
                </div>

                <div class="form-group">
                    <label for="">Enter Delivery Cost</label>
                    <input name="deliveryamount" required type="number" step="0.01" class="form-control">
                </div>


                <div style="margin-top: 12px;">
                    <button type="submit" required class="btn btn-success"> Start Processing</button>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallreport" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Report on Cash Receipts</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
           <form action="{{route('CashierReport')}}" method="GET">
                <!-- Field wrapper start -->
                <div class="field-wrapper">
                    <div class="input-group">
                        <input type="text" name="date" class="form-control custom-daterange">
                        <span class="input-group-text">
                            <i class="icon-calendar1"></i>
                        </span>
                    </div>
                    <div class="field-placeholder">Select Date</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                <button class="btn btn-primary btn-sm">
                    View Report</button>
                </div>

           </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
										<!-- Modal end -->
<script type="text/javascript">
   function customer(id) {
    const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // document.getElementById("demo").innerHTML = this.responseText;
                // console.log(this.responseText);
                // document.getElementById("myData").innerHTML = this.responseText;
                console.log(this.responseText)
                var data = JSON.parse(this.responseText);
                document.getElementById("name").innerHTML = "Name: " + data.customer_name;
                document.getElementById("address").innerHTML =  "Location: " + data.customer_address;
                document.getElementById("phone").innerHTML = "Phone: " +data.customer_phone;
                
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-info/"+ id);
            xhttp.send();
   }

   function markComplete(id) {
    Swal.fire({
        title: 'Are you sure?',
        text: "Do you really want to mark order as Completed!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, Complete it!'
        }).then((result) => {
        if (result.isConfirmed) {
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#highlightRowColumn").load(" #highlightRowColumn");
            }
            xhttp.open("GET", "/ceqa-dashboard/dispatch/"+ id);
            xhttp.send();

            Swal.fire(
            'Confirm!',
            'The Order is Marked Completed.',
            'success'
            )
        }
        })
   }

   function getOrderId(id) {
    const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                console.log(this.responseText)
                var results = JSON.parse(this.responseText);
                document.getElementById("amount").value =  results.order_total_cost;
                document.getElementById("order_number").value =  id;
                

            }
            xhttp.open("GET", "/ceqa-dashboard/order-infomation/"+ id);
            xhttp.send();
   }


   function confirmReject() {
    const swalWithBootstrapButtons = Swal.mixin({
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                    buttonsStyling: false
                    })

                    swalWithBootstrapButtons.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!, contact Administrator for Assistance",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, Mark Rejected!',
                    cancelButtonText: 'No, cancel!',
                    reverseButtons: true
                    }).then((result) => {
                    if (result.isConfirmed) {
                        swalWithBootstrapButtons.fire(
                        'Rejected!',
                        'the Order has been Rejected.',
                        'success'
                        )
                    } else if (
                        /* Read more about handling dismissals below */
                        result.dismiss === Swal.DismissReason.cancel
                    ) {
                        swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Process the Order if neccessary:)',
                        'error'
                        )
                    }
                    })
   }
</script>


@endsection