@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Ordered Date</th>
                                        <th>Product</th>
                                        <th>Quantity</th>												
                                        <th> Unit Price</th>
                                        <th>Total Price</th>
                                        <th>Department</th>
                                        <th>Material Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sales_today_list as $list)
                                    <tr>
                                        <td><strong>#{{$list->invoice_number}}</strong></td>
                                        <td>{{$list->created_at}}</td>
                                        <td>
                                        {{$list->invoice_product_name}}
                                        </td>
                                        <td>
                                        {{$list->invoice_quantity}}
                                        </td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
                                        <td>{{$list->invoice_category}}</td>
                                        <td>
                                            <button id="{{$list->product_id}} - {{$list->invoice_product_name}} - {{$list->invoice_quantity}}" onclick="getComposition(this.id)" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#viewComposition">comp</button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection