@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">

    </div>
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <div class="card">
            <div class="card-header-lg">
            <h5>Today's Report for Raw Materials</h5>
            <form action="{{route('compReportDate')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <select name="show_branch" id="">
                                    <option value="">None</option>
                                    <option value="Branches">Display Branches</option>
                                </select>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn btn-primary"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                </form>
            </div>  

            <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                 <th>Item Code</th>
                                  <th>Item Name</th>
                                  <th>Quantity</th>
                                  <th>Total Used (Kg)/(PC)</th>											  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($comp as $item)
                                <tr>
                                    <td>{{$item->material_code}}</td>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{$item->name}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$item->quantity}}
                                  </td>
                                  <td>
                                  {{$item->total}}
                                  </td>										  
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->


     <!-- Row start -->
     <div class="row gutters">
        <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">View Report By User</div>
                </div>
                <div class="card-body">
                <table id="rowSelection" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Name</th>
                        <th>Branch</th>
                        <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($all_users as $user)
                        <tr>
                        <td>{{$user->name}}</td>
                        <td>{{$user->branch}}</td>
                        <td>
                        <button type="button" id="{{$user->id}}"  onclick="getId(this.id)" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                        <i class="fa fa-eye" aria-hidden="true"></i>
                        </button>
                        
                        </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Branch Report</div>
                </div>
                <div class="card-body">
                
                <table class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Branch Name</th>
                                  <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($all_branch_ as $branches)
                                <tr>												  
                                  <td>{{$branches->branch_name}}</td>
                                  <td>
                                    <button type="button" id="{{$branches->branch_name}}"  onclick="getIdBranch(this.id)" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#staticBackdroprr">
                                    Report
                                    </button>                                 
                                </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                </table>
                </div>
            </div>
        </div>
</div>
    <!-- Row end -->	

</div>
<!-- Content wrapper end -->





<!-- Modal start Sales Report -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">
            Generate Report of <label id="username"></label>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
             <!-- Top Actions - DateRange and Buttons -->
             <form action="{{route('RawMaterialUserReport')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="user_id" id="user_dds" hidden>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<!-- Modal start Branch Report -->
<div class="modal fade" id="staticBackdroprr" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">
            GENERATE REPORT FOR <label id="branch"></label>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
             <!-- Top Actions - DateRange and Buttons -->
             <form action="{{route('RawMaterialBranchReport')}}" method="GET">
                            @csrf
                    <div class="d-flex justify-content-end">
                        <!-- Field wrapper start -->
                        
                        <div class="field-wrapper m-0">
                            <div class="input-group">
                                <input type="text" name="branch" id="branch_input" hidden>
                                <input type="text" name="date" class="form-control custom-daterange2">
                                <span class="input-group-text">
                                    <i class="icon-calendar1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Select Date</div>
                        </div>
                        <!-- Field wrapper end -->
                        <button type="submit" class="btn"><i class="icon-download1"></i> <span>Reports</span></button>
                    </div>
                </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<script>
    function getId(data_user) {
        document.getElementById('user_dds').value = data_user;
        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                // document.getElementById("demo").innerHTML = this.responseText;
                // console.log(this.responseText);
                document.getElementById('username').innerHTML = this.responseText;
            }
            xhttp.open("GET", "/get-user-details/"+data_user);
            xhttp.send();
    }


    function getIdBranch(clicked_id) {
        document.getElementById('branch').innerHTML = clicked_id;
        document.getElementById('branch_input').value = clicked_id;
    }
</script>


@endsection