@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Customer List</h5>
                    <p>Customer Records and Transactions, you can view all transactions by customer</p>
                    <a href="{{route('showNewAndTransactions')}}" style="text-decoration:underline">View Customer Transactions Today</a>
                </div>
            </div>
        </div>
        <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12 col-12">
            <div class="submit-request-card">
                <div>
                    <h5 class="text-info">Add Customer</h5>
                    <p>Add new customer to the system by clicking Add customer</p>
                </div>
                <button class="btn btn-info" data-bs-toggle="modal" data-bs-target="#submitTicketModal"><i class="fas fa-user-plus"></i>Customer</button>
                <div class="modal fade" id="submitTicketModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="submitTicketModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="submitTicketModalLabel">New Customer</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true"></span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form class="row gutters" method="post" action="{{route('customer')}}">
                                    @csrf
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" class="form-control" name="customer_name" placeholder="Enter customer name">
                                            <div class="field-placeholder">Name</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                        <textarea name="customer_address" cols="30" rows="5"></textarea>
                                            <div class="field-placeholder">Address</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="field-wrapper">
                                                <input type="tel" class="form-control" name="customer_phone"  type="tel" pattern="[0-9]{4}[0-9]{4}[0-9]{2}" placeholder="0123456789">
                                                <div class="field-placeholder">Contact</div>
                                            </div>
                                        </div>
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <div class="field-wrapper">
                                                <input type="text" readonly class="form-control" value="{{auth()->user()->name}}" name="customer_enteredby" placeholder="Entered by">
                                                <div class="field-placeholder">Entered by</div>
                                            </div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper m-0">
                                            <textarea class="form-control" name="customer_note" rows="3"></textarea>
                                            <div class="field-placeholder">Note</div>
                                        </div>
                                        <!-- Field wrapper end -->

                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper py-2">
                                        <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="create_inv" value="1" id="flexCheckChecked">
                                        <label class="form-check-label" for="flexCheckChecked">
                                            Create New Invoice
                                        </label>
                                        </div>
                                        </div>
                                        <!-- Field wrapper end -->
                                        
                                        <div class="field-wrapper m-0">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>

                                    
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->


    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table custom-table">
                            <thead>
                                <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>Entered By</th>
                                <th>Last Purc. Branch</th>
                                <th></th>
                                <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($customers as $customer)
                                <tr>
                                <td>{{@strtoupper($customer->customer_name)}}</td>
                                <td>{{$customer->customer_phone}}</td>
                                <td>{{@strtoupper($customer->customer_address)}}</td>
                                <td>{{@strtoupper($customer->customer_enteredby)}}</td>
                                <td>{{@strtoupper($customer->customer_branch)}}</td>
                                <td>
                                @if(auth()->user()->role == "Sales Person")
                                <a href="{{route('index.customer', $customer->id)}}" class="btn btn-outline-primary btn-sm">
                                <i class="icon-shopping-cart1"></i>Order
                                </a>
                                @endif
                                </td>
                                <td>
                                <div class="actions">
                                    <a href="{{route('orders.customer', $customer->id)}}" target="_blank"  title="view All">
                                    <i class="icon-eye1" aria-hidden="true"></i>
                                    </a>
                                
                                    <a href="#" data-toggle="tooltip" onclick="DeleteCustomer(this.id)" id="{{$customer->id}}" data-placement="top" title="" data-original-title="Delete">
                                        <i class="icon-x-circle text-danger"></i>
                                    </a>
                                </div>
                                </td>
                                </tr>
                            @endforeach
                            </tbody>
                    </table>

                    {{$customers->links()}}
                    </div>
                    
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

    <script>
        function DeleteCustomer(id)  {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'Customer Data Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-customer/"+id);
                xhttp.send();
            }
            })
            
        }
    </script>

</div>
<!-- Content wrapper end -->

@endsection