@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">


    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
        <figure class="user-card">
            <figcaption>
                <a href="#" class="edit-card" data-bs-toggle="modal" data-bs-target="#editContact">
                    <i class="icon-mode_edit"></i>
                </a>
                <h5>{{@strtoupper($customer->customer_name)}}</h5>
                <ul class="list-group">
                    <li class="list-group-item"><span>Phone: </span>{{$customer->customer_phone}}</li>
                    <li class="list-group-item"><span>Location: </span>{{$customer->customer_address}}</li>
                    <li class="list-group-item"><button class="btn btn-primary btn-sm"><i class="icon-message"></i> Send Message</button></li>
                </ul>
            </figcaption>
        </figure>

    </div>


        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-body">
                    
                    <div class="custom-tabs-container">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link active" id="first-tab" data-bs-toggle="tab" href="#first" role="tab" aria-controls="first" aria-selected="true">Summary</a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" id="second-tab" data-bs-toggle="tab" href="#second" role="tab" aria-controls="second" aria-selected="false">Orders</a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" id="third-tab" data-bs-toggle="tab" href="#third" role="tab" aria-controls="third" aria-selected="false">Transactions</a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" id="fourth-tab" data-bs-toggle="tab" href="#fourth" role="tab" aria-controls="fourth" aria-selected="false">Reviews</a>
                            </li>
                        </ul>
                        <div class="tab-content" id="myTabContent">
                            <div class="tab-pane fade show active" id="first" role="tabpanel" aria-labelledby="first-tab-label">

                            @include('customer.customer-summary')
                            </div>
                            <div class="tab-pane fade" id="second" role="tabpanel" aria-labelledby="second-tab-label">
                            @include('customer.c-table-order')
                            </div>
                            <div class="tab-pane fade" id="third" role="tabpanel" aria-labelledby="third-tab-label">
                            @include('customer.c-table-products')
                            </div>
                            <div class="tab-pane fade" id="fourth" role="tabpanel" aria-labelledby="fourth-tab-label">
                            @include('customer.c-table-review')
                            </div>
                        </div>
                       @if(auth()->user()->role == "Sales Person")
                       <div class="form-actions-footer">
                            <div class="text-end">
                                <a href="{{route('index.customer', $customer->id)}}" class="btn btn-primary ms-1">Create Invoice</a>
                            </div>
                        </div>
                        @endif
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->





<!-- Modal start -->
<div class="modal fade" id="exampleModalReview" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Add Customer Review</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               
            @include('inc.review-form')
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

@endsection