<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Title -->
		<title>Welcome ~ CeqaFoods and Beverages Limited</title>

		<!-- Date Range CSS -->
		<link rel="stylesheet" href="{{asset('vendor/daterange/daterange.css')}}">

		
		<!-- Uploader CSS -->
		<link rel="stylesheet" href="{{asset('vendor/dropzone/dropzone.min.css')}}" />

		<!-- *************
			************ Common Css Files *************
		************ -->
		<!-- Bootstrap css -->
		<link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
		
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('fonts/style.css')}}">

		<!-- Main css -->
		<link rel="stylesheet" href="{{asset('css/main.css')}}">

		<!-- fontAwesome -->
		<link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">
        <!-- <meta http-equiv="refresh" content="5"> -->


		<!-- Data Tables -->
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4.css')}}" />
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4-custom.css')}}" />
		<link href="{{asset('vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		
		<script src="{{asset('js/ajax.min.js')}}"></script>

		<!-- *************
			************ Vendor Css Files *************
		************ -->
		<!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />
		<!-- Mega Menu -->
		<link rel="stylesheet" href="{{asset('vendor/megamenu/css/megamenu.css')}}">
		<!-- Search Filter JS -->
		<link rel="stylesheet" href="{{asset('vendor/search-filter/search-filter.css')}}">
		<link rel="stylesheet" href="{{asset('vendor/search-filter/custom-search-filter.css')}}">
        		<!-- Sweet Alert-->
		<link href="{{asset('vendor/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />
	</head>
	<body>

    <style>
        body{
            background-color: #cbd4fe;
        }

    </style>



<!-- Row start -->
<div style="width:100%" id="main">

 <!-- Breadcrumb container start -->
 <div class="breadcrumb-container" style="background-color:#ffffff; box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);">
 <img src="/img/{{$app->app_logo}}" alt="Logo" style="max-height:45px">
<span>
<a href="{{route('OnlinePNP')}}" class="btn btn-outline-primary"><i class="icon-shopping-cart1"></i> E-shop Orders ({{$pendingCount->count()}})</a>
<a href="{{route('OnlineAgency')}}" class="btn btn-outline-primary"><i class="icon-shopping-cart1"></i> Agency Orders ({{$agencycount}})</a>
@if(auth()->user()->role == "Cashier")
<a href="{{route('CashierReport')}}" class="btn btn-outline-primary"><i class="icon-area-graph"></i> Report</a>
@else
<a href="{{route('acceptTransfer')}}" class="btn btn-outline-primary"><i class="icon-send"></i> Transfer</a>
@endif
<a href="/" class="btn btn-outline-primary"><i class="icon-arrow_back"></i> Back</a>
</span>

<span style="float:right; padding:10px" class="text-primary">
    ORDER DISPLAY | {{auth()->user()->branch}} [{{auth()->user()->name}}]
</span>

</div>
<!-- Breadcrumb container end -->

        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Card start -->
            <div>
                <div class="card-body">

                <!-- Row start -->
                <div class="row gutters">
                    @foreach($order as $number => $item)
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
                        <figure class="user-card"  style="box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);">
                            <figcaption>
                            
                            <div style="width:100%; background-color:#cbd4fe; padding:12px">
                            <span>#{{$number}}</span><br>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped m-0">
                                <thead class="thead-light">
                                    <tr>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Item</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Qty</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Total Price</th>
                                    </tr>
                                </thead>
                                    <tbody>
                                    @foreach($item as $item)
                                        <tr>
                                        <td>{!!$item->invoice_product_name!!}</td>
                                        <td>{{$item->invoice_quantity}} PCS</td>
                                        <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->invoice_total_price)</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                                </div>
                            </figcaption>
                            <div style="margin-top:10px">
                            <a href="{{route('orderTransaction', $item->invoice_number)}}" target="_blank" class="btn btn-info btn-sm"><i class="icon-print"></i> Print Order</a>
                            <a href="#" class="btn btn-outline-info btn-sm"><i class="icon-time-slot"></i>
                            <?=  \Carbon\Carbon::parse($item->created_at)->diffForHumans() ?>
                            </a><br><br>
                            </div>
                        </figure>
                    </div>
                    @endforeach
                    
        </div>
    </div>
    <!-- Row end -->




<!-- Sweet Alerts js -->
<script src="{{asset('vendor/libs/sweetalert2/sweetalert2.min.js')}}"></script>
    <script>
        function CompleteTransaction() {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Complete Order!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/complete/complete-transaction"
                    Swal.fire(
                    'Mark Complete!',
                    'The Order will clear from the Screen',
                    'success'
                    )
                }
                })
        }
        
    </script>

    @include('inc.check-internet')





    		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->
		
		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>