@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
<div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
        <figure class="user-card">
            <figcaption>
                <h5>REPORT BY CATEGORY - {{@strtoupper(request('branch'))}}</h5>
                <ul class="list-group">
                    <li class="list-group-item"><span>Date: </span>{{request('date')}}</li>
                    <li class="list-group-item"><span>Total Quantity: </span>{{$itemsQuantity}}</li>
                    <li class="list-group-item"><span>Total Cash: </span>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($itemsPrice)</li>
                </ul>
            </figcaption>
        </figure>
    </div>
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Products</th>
                                  <th>Quantity</th>
                                  <th>Total</th>
                                  <th>Action</th>													  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{@strtoupper($item->name)}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$item->quantity}}
                                  </td>
                                  <td>
                                  GH₵@convert($item->total)
                                  </td>		
                                  <td>
                                    <form action="{{route('showDepartmentItemDate')}}" method="get">
                                        <input type="text" name="name" value="{{@strtoupper($item->name)}}" hidden>
                                        <input type="text" name="date" value="{{request()->date}}"hidden >
                                        @if(request()->branch == null)@else
                                        <input type="text" name="branch" value="{{request()->branch}}" hidden>
                                        @endif
                                        <button class="btn btn-outline-primary btn-sm"> <i class="icon-eye1"></i> </button>
                                    </form>
                                  </td>											  
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection