@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
   
    <div class="row gutters">
   
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Delivery Prices</div>
                </div>
                <div class="card-body">
                    <form action="{{route('loadLocations')}}" method="post" enctype="multipart/form-data">
                                @csrf
                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                
                                <!-- Field wrapper start -->
                                <div class="field-wrapper">
                                    <div class="input-group">														
                                        <input type="file" name="file" class="form-control" id="inputGroupFile01">
                                        <button class="btn btn-outline-primary" type="submit" required>Upload</button>
                                    </div>
                                    <div class="field-placeholder">Import Delivery Prices</div>
                                    <small class="text-primary"><a href="/uploads/dispatch_items.csv">Download Sample CSV</a></small>
                                </div>
                                <!-- Field wrapper end -->

                            </div>
                        </div>
                        <!-- Row end -->
                    </form>
                    
                <form action="{{route('DeleteDispatchItem')}}" id="form-id" method="POST">
                    @csrf
                    <!-- Row start -->
                    <div class="row gutters">
                    <div class="table-responsive">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th><input type="checkbox" id="select-all"></th>
                            <th>Location</th>
                            <th>Outlet</th>
                            <th>Price</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dispatch_details as $details)
                        <tr>
                            <td><input type="checkbox" name="dispatchitem[]" value="{{$details->id}}"></td>
                            <td>{{$details->location_name}}</td>
                            <td>{{$details->location_branch}}</td>
                            <td>GH₵{{$details->location_price}}</td>
                            <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit" data-bs-toggle="modal" data-bs-target="#DeliveryPrice<?=$details->id?>">
                                    <i class="icon-edit1 text-info"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="#" data-toggle="tooltip" id="{{$details->id}}" onclick="DeleteDispatch(this.id)" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                    </table>
                    </div>
                    </div>
                    </form>
                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
												
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">														
                                <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">Action</button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li><a class="dropdown-item" href="#">Download</a></li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item" href="#" onclick="document.getElementById('form-id').submit();">Delete</a></li>
                                </ul>
                            </div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                </div>
            </div>
            <!-- Card end -->
        </div>
        

        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Pricing</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form id="location">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="location_name">
                                <div class="field-placeholder">Name of Location<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input required class="form-control" type="text" name="location_price">
                                <div class="field-placeholder">Price / Amount <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select name="location_branch" class="form-control">
                                @foreach($all_branch as $branch)
                                <option value="{{$branch}}">{{$branch}}</option>
                                @endforeach
                            </select>
                                <div class="field-placeholder">Outlet<span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->



@foreach($dispatch_details as $prices)
<!-- Modal start -->
<div class="modal fade" id="DeliveryPrice<?=$prices->id?>" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">{{@strtoupper($prices->location_name)}}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            <form action="{{route('updateDispatch', $prices->id)}}" method="post">
            @csrf
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" required type="text" name="location_name" value="{{@strtoupper($prices->location_name)}}">
                        <div class="field-placeholder">Name of Location<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input required class="form-control" value="{{$prices->location_price}}" type="text" name="location_price">
                        <div class="field-placeholder">Price / Amount <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>


                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                    <select name="location_branch" class="form-control">
                        <option value="{{$prices->location_branch}}" selected>{{$prices->location_branch}}</option>
                        @foreach($all_branch as $branch)
                        <option value="{{$branch}}">{{$branch}}</option>
                        @endforeach
                    </select>
                        <div class="field-placeholder">Outlet<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <button class="btn btn-primary" >Submit</button>
                </div>
                </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->
@endforeach


<script type="text/javascript">
    
    $("#location").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.dispatchItem')}}",
                dataType: "json",
                data: $('#location').serialize(),
                success: function(data){
                    $("#location")[0].reset();
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New Branch Added Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });




        function DeleteDispatch(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#copy-print-csv").load(" #copy-print-csv");
                    Swal.fire(
                        'Deleted!',
                        'Dispatch Item Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/dispatch-item/"+id);
                xhttp.send();
            }
            })
            
        }

</script>


<script type="text/javascript">  
    document.getElementById('select-all').onclick = function(){
        var ele=document.getElementsByName('dispatchitem[]');  
        for (var checkbox of ele) {
                checkbox.checked = this.checked;
            }
    
    }              
</script> 


@endsection