@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

<!-- Row start -->
<div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Task section start -->
            <div class="tasks-section">

                <!-- Labels container start -->
                <div class="labels-container">
                    <div class="lablesContainerScroll">
                        <div class="filters-block">
                            <h5>Filters</h5>
                            <div class="filters">
                                <a href="{{route('TransferOrder')}}">
                                    <i class="icon-receipt"></i> All
                                </a>
                                <a href="{{route('TransferOrderPending')}}" class="active">
                                    <i class="icon-error"></i> Pending Transfers
                                </a>
                                <a href="{{route('TransferOrderAccepted')}}">
                                    <i class="icon-check_circle"></i> Accepted Transfers
                                </a>
                            </div>
                        </div>											
                    </div>
                </div>
                <!-- Labels container end -->

                <!-- Tasks container start -->
                <div class="tasks-container">
                    
                    <div class="tasks-header">
                        <h3>Unapproved Transfers <span>{{$getDayClose->day_close}}</span></h3>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"> <i class="icon-shopping-cart1"></i> New Sale</button>
                    </div>
                    <div class="tasksContainerScroll">
                         <!-- Card start -->
                                <div class="table-responsive">
                                <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                            <th>Invoice Number</th>
                            <th>Created at</th>
                            <th>Status</th>
                            <th>Transfer to</th>
                            <th>Description</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($transactions as $order)
                        <tr>
                            <td> <a href="{{route('orderTransaction',$order->order_number)}}">#{{$order->order_number}}</a> 
                            <p>Created at: {{ \Carbon\Carbon::parse($order->created_at)->diffForHumans() }}</p>
                            </td>
                            <td>{{$order->created_at}}</td>
                            <td>{!! $order->status == 2 ? '<span class="badge rounded-pill bg-danger">' . "Pending" . '</span>' : '<span class="badge rounded-pill bg-secondary">' . "Accepted" . '</span>'!!}</td>
                            <td>{{$order->transfer_to}}</td>
                            <td>{{$order->description}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                        </div>
                        <!-- Card end -->

                    </div>
                </div>
                <!-- Tasks container end -->

            </div>
            <!-- Task section end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection