@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <div class="profile-header">
                <h1>Dispatch Report from {{request()->date}}</h1>
                <div class="profile-header-content">
                    <div class="profile-header-tiles">
                        <div class="row gutters">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="profile-tile">
                                    <span class="icon">
                                        <i class="icon-server"></i>
                                    </span>
                                    <h6>Name - <span>{{$rider->rd_name}}</span></h6>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="profile-tile">
                                    <span class="icon">
                                        <i class="icon-map-pin"></i>
                                    </span>
                                    <h6>Location - <span>{{$rider->rd_address}}</span></h6>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                                <div class="profile-tile">
                                    <span class="icon">
                                        <i class="icon-phone1"></i>
                                    </span>
                                    <h6>Phone - <span>{{$rider->rd_phone}}</span></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile-avatar-tile">
                        <img src="img/user1.png" class="img-fluid" alt="User Profile" />
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->
    
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12">
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Card start -->
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Deliveries List</div>
                        </div>
                        <div class="card-body">
                        <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                                <thead>
                                    <tr>
                                        <th>Order No.</th>
                                        <th>Dispatch Manager</th>
                                        <th>Payment Type</th>
                                        <th>Order Cost</th>												
                                        <th>Delivery Cost</th>
                                        <th>Related Branch</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($results as $list)
                                    <tr>
                                        <td>#{{$list->order_number}}</td>
                                        <td>{{$list->entered_by}}</td>
                                        <td>
                                        {{$list->momo}}
                                        </td>
                                        <td>GH¢
                                        <?= $list->amount - $list->deliveryamount ?>
                                        </td>
                                        <td>GH₵{{$list->deliveryamount}}</td>
                                        <td>{{$list->dispatch_branch}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        </div>
                    </div>
                    <!-- Card end -->
                </div>
            </div>
            <!-- Row end -->
        </div>
        <div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <!-- Card start -->
                    <div class="stats-tile4 min-height">                                            
                        <div class="stats-icon4">
                            <i class="icon-receipt"></i>
                        </div>
                        <h3>GH¢{{$deliveryamount}}</h3>
                        <h4>Income Generated</h4>
                    </div>
                    <!-- Card end -->
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <!-- Card start -->
                    <div class="stats-tile4 min-height">                                            
                        <div class="stats-icon4">
                            <i class="icon-stars"></i>
                        </div>
                        <h3>{{$results->count()}}</h3>
                        <h4>Deliveries Made</h4>
                    </div>
                    <!-- Card end -->
                </div>
             </div>
            </div>
            <!-- Row end -->                                
        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->



@endsection