@extends('layouts.app')

@section('content')

@if(auth()->user()->role == "Sales Person")
<script>
    $(document).ready(function(){
        $('#staticBackdropdeliverypopup').modal('show')
        }) 
</script>
@endif

<!-- Notify Sales Person Modal -->

<div class="modal fade" id="Notifysale" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Notification</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
            Dear {{auth()->user()->name}}, <br>
                <p><h5>You are currently signed in to the <strong>{{auth()->user()->branch}}.</strong></h5></p>
                <p>Need assistance switching current Branch? Contact Administrator : <strong>0501429671</strong> or <strong>0574660657</strong></p>
            </div>
            <div class="modal-footer">
                <a href="{{route('index.invoice')}}" class="btn btn-secondary"><i class="icon-shopping-cart1" aria-hidden="true"></i> Proceed to Sales</a>
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">
    
    <!-- Content wrapper start -->
    <div class="content-wrapper">


    <!-- Row start -->
<div class="row gutters">
    <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <h5 class="m-0">Welcome Back, {{auth()->user()->name}}! </h5> 
        <small>Logged In at: <b class="text-primary">{{ \Carbon\Carbon::parse(auth()->user()->last_seen)->diffForHumans() }}</b>,
        Active Date: {{$dayClose->day_close}},
        Outlet: {{auth()->user()->branch}}

        </small>

        <!-- Consultants banner start -->
        <div class="consulting-banner">
            <div class="consulting-banner-bg"></div>
            <div class="consulting-body">
                <div class="consulting-content">
                    <h4>{{$app->app_name}} POS!</h4>
                    <p>To make the experience hassle-free, <br /> Kindly read our user guide or watch our video tutorials</p>
                </div>
            </div>
        </div>
        <!-- Consultants banner end -->
        
    </div>
    <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
        
        <!-- Consultants card start -->
        <div class="consulting-card">
            <div class="consulting-card-bg"></div>
            <div class="consulting-card-body">
                <h4>Get Started</h4>
                Hey there! <br>
                <p>We have assembled some links to get you started</p>
                @if(auth()->user()->role != "Administrator")
                    @if(auth()->user()->role == "Call Center")
                    <button class="btn btn-primary stripes-btn" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</button>  
                    @else
                    <button class="btn btn-primary stripes-btn" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Sale</button>                                       
                    @endif
                @else
                <a href="{{route('index.branch')}}" class="btn btn-primary stripes-btn">New Outlet</a>
                @endif
            </div>
        </div>
        <!-- Consultants card end -->
        
    </div>
</div>
<!-- Row end -->

        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                        <i class="icon-shopping-bag1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{$countproduct}}</h2>
                        <p><a href="{{route('productList')}}">Products</a></p>
                    </div>
                    <div class="sale-graph">
                        <div id="sparklineLine1"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-12">
                <div class="stats-tile">
                    <div class="sale-icon">
                    <i class="icon-shopping-cart1"></i>
                    </div>
                    <div class="sale-details">
                        <h2>{{$orders}}</h2>
                        <p><a href="{{route('AllOrders')}}">Orders</a></p>
                    </div>
                    <div class="sale-graph">
                        <div id="sparklineLine2"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
                <div class="stats-tile">
                        <div class="sale-icon">
                            <i class="icon-credit-card"></i>
                        </div>
                        <div class="sale-details">
                        <!-- <h2><tt>GH₵{{$total_sales == 0 ? "0.00" : $total_sales}}</tt></h2> -->
                        @if(auth()->user()->role == "Administrator")
                        <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total_sales)</h2>
                        <p><a href="{{route('sales.today')}}">END OF DAY</a></p>
                        @elseif(auth()->user()->role == "Branch Officer")
                        <h3><a href="{{route('sales.today')}}" class="text-primary"><strong>END OF DAY</strong></a></h3>
                        @else
                        <h3><a href="{{route('salesTodayBySalesPerson')}}" class="text-primary"><strong>END OF DAY</strong></a></h3>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- Row end -->

        @can('create', App\Models\User::class)
        <!-- Row start -->
        <div class="row gutters">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 cool-12">

                <div class="card">
                @if(auth()->user()->role == "Administrator")
                <div class="card-header">
                    <a href="{{route('departmentSummaryAdmin')}}" class="btn btn-outline-primary btn-sm rounded-pill"> Category Report</a>
                    <a href="{{route('ItemSummaryAdmin')}}" class="btn btn-outline-primary btn-sm rounded-pill"> Product Report</a>
                </div>
                <hr>
                @endif
                    <div class="card-body">
                        <!-- Row start -->
                        <div class="row gutters">											
                            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-12">
                                <div class="reports-summary">
                                    
                                    
                                    
                                    <form action="{{route('branchSales')}}" method="get">
                                          @csrf
                                    <div class="field-wrapper">
                                    <select class="form-control @error('branch') is-invalid @enderror" required name="branch">
									<option disabled selected>Select Outlet</option>
									    @foreach($all_branch as $branch)
										<option value="{{$branch}}">{{$branch}}</option>
										@endforeach
                                    </select>
                                        <div class="field-placeholder">Report Type</div>
									</div>
                                        <button class="btn btn-primary stripes-btn">Generate Report</button>
                                    </form>
                                </div>
                            </div>
                            <div class="col-xl-9 col-lg-9 col-md-8 col-sm-8 col-12">
                                <div class="row gutters">
                                    <div class="col-12">
                                        <div class="graph-day-selection mt-2" role="group">
                                            <button type="button" class="btn active">Today</button>
                                            <button type="button" class="btn">Yesterday</button>
                                            <button type="button" class="btn">7 days</button>
                                            <button type="button" class="btn">15 days</button>
                                            <button type="button" class="btn">30 days</button>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div id="salesGraph" class="chart-height-xl"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->
                    </div>
                </div>

            </div>
        </div>
        <!-- Row end -->
        @endcan

        <!-- Row start -->
        <div class="row gutters">

                <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-question_answer"></i>
                        </div>
                        <div class="sale-details">
                            <p>Get Started FAQ</p>
                        </div>
                    </div>
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-local_library"></i>
                        </div>
                        <div class="sale-details">
                            <p>Knowledge Articles</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-12">
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-video"></i>
                        </div>
                        <div class="sale-details">
                            <p>Video Tutorial</p>
                        </div>
                    </div>
                    <div class="stats-tile2">
                        <div class="sale-icon">
                            <i class="icon-headphones"></i>
                        </div>
                        <div class="sale-details">
                            <p>Customer Support</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-8 col-lg-6 col-md-12 col-sm-12 col-12">

                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">Active Users</div>
                        </div>
                        <div class="card-body">
                        @include('inc.online-status')
                        </div>
                    </div>

                </div>
                <!-- Row end -->
        </div>
    </div>
    <!-- Content wrapper end -->

    
<script>
    function getComposition(data) {
        
        const id = data.split(" - ")
        document.getElementById('mySmallModalLabel').innerHTML = id[1]

        const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                data = JSON.parse(this.responseText);
                var list = "<ul>";
                    for (let i of data) {
                    list += `<li>${i.product_name} = ${i.unit_measure}, Total Used: ${i.unit_measure*id[2]}</li>`;
                    }
                    list += "</ul>";

                document.getElementById("demoB").innerHTML = list;

            }
            xhttp.open("GET", "/ceqa-dashboard/compostions-product/"+ id[0]);
            xhttp.send();
    }
</script>
@endsection
