<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Title -->
		<title>Welcome ~ CeqaFoods and Beverages Limited</title>

		<!-- Date Range CSS -->
		<link rel="stylesheet" href="{{asset('vendor/daterange/daterange.css')}}">

		
		<!-- Uploader CSS -->
		<link rel="stylesheet" href="{{asset('vendor/dropzone/dropzone.min.css')}}" />

		<!-- *************
			************ Common Css Files *************
		************ -->
		<!-- Bootstrap css -->
		<link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">
		
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('fonts/style.css')}}">

		<!-- Main css -->
		<link rel="stylesheet" href="{{asset('css/main.css')}}">

		<!-- fontAwesome -->
		<link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">
        <!-- <meta http-equiv="refresh" content="5"> -->


		<!-- Data Tables -->
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4.css')}}" />
		<link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4-custom.css')}}" />
		<link href="{{asset('vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- sweet Alert2 -->
		<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

		<script src="{{asset('js/ajax.min.js')}}"></script>

		<!-- *************
			************ Vendor Css Files *************
		************ -->

		<!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />

		<!-- Mega Menu -->
		<link rel="stylesheet" href="{{asset('vendor/megamenu/css/megamenu.css')}}">

		<!-- Search Filter JS -->
		<link rel="stylesheet" href="{{asset('vendor/search-filter/search-filter.css')}}">
		<link rel="stylesheet" href="{{asset('vendor/search-filter/custom-search-filter.css')}}">
		
		<script>
            window.onload = function reload(){
                function autoRefresh_div() {
                    $("#main").load("/orders-from-drive-through/check-to-complete", function() {
                        setTimeout(autoRefresh_div, 5000);
                    });
                }

                autoRefresh_div();
            }
        </script>
	</head>
	<body>

    <style>
        body{
            background-color: #fa7970;
        }

        th, td, table {
            font-size:15px
        }
    </style>


    <!-- Row start -->
    <div class="row gutters" id="main">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div>
                
                <div class="card-body">

                <!-- Row start -->
                <div class="row gutters">
                    @foreach($order as $number => $item)
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 col-12">
                        <figure class="user-card"  style="box-shadow: 2px 2px 2px 1px rgba(0, 0, 0, 0.2);">
                            <figcaption>
                                <h5><span class="badge rounded-pill bg-primary">#{{$number}}</span></h5>
                                <table class="table">
                                <thead class="thead-light">
                                    <tr>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Item</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Qty</th>
                                    <th scope="col" style="font-size:12px; border-top:1px solid #000; border-bottom:1px solid #000 ; padding:5px">Total Price</th>
                                    </tr>
                                </thead>
                                    <tbody>
                                    @foreach($item as $item)
                                        <tr>
                                        <td><strong>{!!$item->invoice_product_name!!}</strong></td>
                                        <td>{{$item->invoice_quantity}} PCS</td>
                                        <td>GH₵@convert($item->invoice_total_price)</td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </figcaption>
                            <a href="" class="btn btn-info btn-sm">{{$loop->iteration}}</a>
                            <a href="" class="btn btn-primary btn-sm"><i class="far fa-clock"></i>
                            <?=  \Carbon\Carbon::parse($item->created_at)->diffForHumans() ?>
                            </a>
                            <a href="#" id="{{$number}}" onclick="invoiceNumber(this.id)" class="btn btn-primary btn-sm">Mark Completed</a>
                        </figure>
                    </div>
                    @endforeach
                    
        </div>
    </div>
    <!-- Row end -->





    <script>
        function invoiceNumber(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Complete Order!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/orders-from-drive-through/complete-transaction/" + id
                    Swal.fire(
                    'Mark Complete!',
                    'The Order will clear from the Screen',
                    'success'
                    )
                }
                })
        }
    </script>






    		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->
		
		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>