<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>{{$app->app_name}} - Product List</title>
        <link rel="icon" type="image/x-icon" href="/img/{{$app->app_logo}}">

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('vendor/search-filter/custom-search-filter.css')}}">
	</head>

<body>

<div class="card-body">
    

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <!-- Breadcrumb container start -->
            <div class="breadcrumb-container">

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#l">Home</a></li>
                        <li class="breadcrumb-item"><a href="/">Dashboards</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Export Menu Items</li>
                        </ol>
                    </nav>
                </div>
                @if(auth()->user()->role == "Sales Person" || auth()->user()->role == "Call Center")
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                    <!-- Top Actions - DateRange and Buttons -->
                    <div class="d-flex justify-content-end">
                        <a href="#" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral"><i class="icon-shopping-cart1"></i> New Sale</a>
                    </div>
                </div>
                @endif
            </div>
            <!-- Row end -->

            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
    <table id="copy-print-csv" class="table custom-table">
        <thead>
            <tr>
            <th>Products</th>	
            <th>Product Code</th>		
            <th>Product Category</th>											  
            <th>Unit Price</th>
            </tr>
        </thead>
        <tbody>
        @foreach($items_product as $item)
            <tr>
                <td>
                    <div class="media-box">
                        <div class="media-box-body">
                            <a href="#" class="text-truncate">{!!@strtoupper($item->Name)!!}</a>
                        </div>
                    </div>
                </td>
                <td>{{@strtoupper($item->product_code)}}</td>	
                <td>{{@strtoupper($item->production_category)}}</td>													  
                <td> {{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->UnitPrice)</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    </div>

</div>




		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>
