<!-- Modal start -->
<div class="modal fade" id="exampleModalFullScreen" tabindex="-1" aria-labelledby="exampleModalFullScreenTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalFullScreenTitle">Add Customer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                
            <form id="savecustomer">
                            @csrf
                        <input type="text" value="1" name="create_inv" hidden readonly>
                        <!-- Row start -->
                        <div class="row justify-content-between">

                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">

                                <!-- Row start -->
                                <div class="row gutters">

                                    <div class="col-12">
                                        <div class="form-section-header light-bg">Customer Details</div>
                                    </div>
                                    <div class="col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input class="form-control" type="text" name="customer_name" required>
                                            <div class="field-placeholder">Customer Name <span class="text-danger">*</span></div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <textarea class="form-control" name="customer_address" rows="3"></textarea>
                                            <div class="field-placeholder">Address</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
                                    <div class="col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input class="form-control" type="text" name="customer_phone" required>
                                            <div class="field-placeholder">Contact Number</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                </div>
                                <!-- Row end -->

                            </div>
                            <div class="col-xl-5 col-lg-5 col-md-7 col-sm-7 col-12">

                                <!-- Row start -->
                                <div class="row gutters">

                                    <div class="col-12">
                                        <div class="form-section-header light-bg">Other Information</div>
                                    </div>

                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <input type="text" name="customer_eneteredby" readonly class="form-control" value="{{auth()->user()->name}}">
                                            <div class="field-placeholder">Entered by</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>
    
                                    <div class="col-12">
                                        <!-- Field wrapper start -->
                                        <div class="field-wrapper">
                                            <textarea class="form-control" name="customer_note" rows="3"></textarea>
                                            <div class="field-placeholder">Notes</div>
                                        </div>
                                        <!-- Field wrapper end -->
                                    </div>

                                </div>
                                <!-- Row end -->

                            </div>

                        </div>
                        <!-- Row end -->

                        
                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="form-actions-footer">
                                    <div class="text-end">
                                        <button class="btn btn-primary">Add Customer</button>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- Row end -->

                        </form>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
    <!-- Modal end -->


<script>
     $("#savecustomer").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('customerDrive')}}",
                dataType: "json",
                data: $('#savecustomer').serialize(),
                success: function(data){
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Customer Added Successfully'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>