<!-- Modal start -->
<div class="modal fade" id="staticBackdropRegister" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="staticBackdropLabel">Add New User</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
        <form id="newuser">
            @csrf
			<div class="field-wrapper">
                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>

                @error('name')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <div class="field-placeholder">Full Name</div>
			</div>

            <div class="field-wrapper">
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">

                @error('email')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <div class="field-placeholder">Email ID</div>
			</div>

			<div class="field-wrapper">
            <select class="form-control @error('role') is-invalid @enderror" name="role">
                <option value="Sales Person">PHARMACIST</option>
                <option value="Sales Person">MC ASSISTANT</option>
                <option value="Sales Person">DISPENSING TECHNICIAN</option>
                <option value="Sales Person">SUPPORTING STAFF</option>
                <option value="Cashier">CASHIER</option>
                <option value="Administrator">ADMINISTRATOR</option>
            </select>

                @error('role')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <div class="field-placeholder">Role</div>
			</div>

			<div class="field-wrapper">
            <select class="form-control @error('Branch') is-invalid @enderror" name="branch" required>
			<option selected disabled>Select Branch</option>
			    @foreach($all_branch as $branch)
				<option value="{{$branch}}">{{$branch}}</option>
				@endforeach
            </select>

                @error('branch')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <div class="field-placeholder">BRANCH OFFICE</div>
			</div>
            
			<div class="field-wrapper">
			<select class="form-control @error('Branch') is-invalid @enderror" name="sales_person_category" required>
			<option value="Counter">Counter</option>
			<option value="Delivery">Delivery</option>
            </select>

                @error('branch')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
                <div class="field-placeholder">SALES PERSON CATEGORY</div>
			</div>

			<div class="field-wrapper">
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">

                @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
				<div class="field-placeholder">Password</div>
			</div>

			<div class="field-wrapper mb-3">
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
				<div class="field-placeholder">Confirm Password</div>
			</div>
			<div class="actions">
				<button type="submit" class="btn btn-primary ms-auto">Sign Up</button>
			</div>
        </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
</div>
<!-- Modal end -->


<script type="text/javascript">
    
    $("#newuser").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('registerUser')}}",
                dataType: "json",
                data: $('#newuser').serialize(),
                success: function(data){
                    $("#newuser")[0].reset();
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New User Added Successfully'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>