    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Beneficiary</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="highlightRowColumn" class="table custom-table table-sm">
                    <thead>
                        <tr>
                            <th>Beneficiary Name</th>
                            <th>Phone Numbers</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($house_person as $person)
                        <tr>
                            <td>{{@strtoupper($person->name)}}</td>
                            <td>{{$person -> phone}}</td>
                            <td>
                              <a href="{{route('HouseSummary', $person-> id)}}" class="btn btn-outline-primary btn-sm">view</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Beneficiary</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form id="onthehouseperson">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="name">
                                <div class="field-placeholder">Name <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="text" name="phone">
                                <div class="field-placeholder">Phone Number <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                       
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <textarea class="form-control" rows="2" name="decription"></textarea>
                                <div class="field-placeholder">Description</div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->




    <script type="text/javascript">
    
    $("#onthehouseperson").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.HousePerson')}}",
                dataType: "json",
                data: $('#onthehouseperson').serialize(),
                success: function(data){
                    $("#onthehouseperson")[0].reset();
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Officer Successfully Added to On the House Form'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function DeleteBranch(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    Swal.fire(
                        'Deleted!',
                        'Branch Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-branch/"+id);
                xhttp.send();
            }
            })
            
        }
</script>


