@extends('layouts.app')

@section('content')
<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header-lg">
                    <h4>Preview</h4>
                    
                </div>
                <div class="card-body">

                    <div class="invoice-container">

                        <div class="invoice-header">
                            <!-- Row start -->
                            <div class="row justify-content-between">
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                </div>
                                <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                                    <address class="text-right">
                                    {!!empty($customer_info->comment) ? "": "NOTE: " . '<span class="text-danger">' . $customer_info->comment . '</span>'!!}
                                    </address>
                                </div>
                            </div>
                            <!-- Row end -->
                        </div>

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="invoice-details">
                                    <address class="m-0">
                                    <strong>Customer Information</strong><br>
                                    {{$customer_info->customer_fname}} {{$customer_info->customer_lname}},<br>
                                    {{$customer_info->delivery_location}}<br>
                                    {{$customer_info->customer_phone}}
                                    </address>

                                    <div class="invoice-num">
                                        <div>Order ID - #{{$customer_info->invoice_number}}</div>
                                        <div>Purchase Date: <?php 
                                            $date = \Carbon\Carbon::parse($customer_info->created_at, 'UTC');
                                            echo $date->isoFormat('MMMM Do YYYY, h:mma');
                                            ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">
                            <div class="col-12">
                                
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Items</th>
                                                <th>Quantity</th>
                                                <th>Unit Price</th>
                                                <th>Total Amount (Net)</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($customer_orders as $customer_orders)
                                            <tr>
                                                <td>
                                                    {{$customer_orders->item_name}}
                                                </td>
                                                <td>
                                                    {{$customer_orders->item_quantity_purchased}}
                                                </td>
                                                <td>
                                                    {{empty($app->currency) ? "GHS" : $app->currency}}@convert($customer_orders->item_unit_price)
                                                </td>
                                                <td>
                                                    {{empty($app->currency) ? "GHS" : $app->currency}}@convert($customer_orders->item_quantity_purchased * $customer_orders->item_unit_price)
                                                </td>
                                            </tr>
                                            @endforeach
                                            <tr>
                                                <td>
                                                </td>
                                                <td>
                                                </td>
                                                <td>
                                                    <h6>Total</h6>
                                                </td>
                                                <td>
                                                    <h6>
                                                    {{empty($app->currency) ? "GHS" : $app->currency}}@convert($totaling)
                                                    </h6>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                        <!-- Row end -->

                        <!-- Row start -->
                        <div class="row gutters">

                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="text-start">
                                    <button class="btn btn-outline-primary rounded-pill"  data-bs-toggle="modal" data-bs-target="#AcceptPrint">Accept & Print</button>
                                    <button class="btn btn-outline-info rounded-pill ms-1">Print</button>
                                    <button class="btn ms-1 btn-outline-primary rounded-pill" data-bs-toggle="modal" data-bs-target="#Cancel"><i class="icon-slash"></i>Cancel</button>
                                    <form action="#" method="get" id="cancel">
                                         <input type="text" name="order_id" hidden value="{{$customer_info->invoice_number}}">
                                    </form>
                                    <form action="#" method="get" id="ap">
                                         <input type="text" name="order_id" hidden value="{{$customer_info->invoice_number}}">
                                    </form>
                                </div>
                            </div>

                        </div>
                        <!-- Row end -->
                    
                    </div>

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<!-- Modal start -->
<div class="modal fade" id="AcceptPrint" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Accept & Generate Receipt</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                You won't be able to make change to the invoice after submititng, kindly confirm
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="document.getElementById('ap').submit();">Confirm</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<!-- Modal start -->
<div class="modal fade" id="Cancel" tabindex="-1" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalCenterTitle">Confirm Cancel</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h5>Are you Sure? you won't be able to revert</h5>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="document.getElementById('cancel').submit();">Confirm Cancel</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->


@endsection