<!doctype html>
<html lang="en">
	
<head>
		<!-- Required meta tags -->
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<!-- Meta -->
		<meta name="description" content="Responsive Bootstrap4 Dashboard Template">
		<meta name="author" content="ParkerThemes">
		<link rel="shortcut icon" href="img/fav.png">

		<!-- Title -->
		<title>{{$app->app_name}} - Sales Transactions</title>
        <link rel="icon" type="image/x-icon" href="/img/{{$app->app_logo}}">

        <!-- Date Range CSS -->
        <link rel="stylesheet" href="{{asset('vendor/daterange/daterange.css')}}">

                
        <!-- Uploader CSS -->
        <link rel="stylesheet" href="{{asset('vendor/dropzone/dropzone.min.css')}}" />

        <!-- *************
            ************ Common Css Files *************
        ************ -->
        <!-- Bootstrap css -->
        <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">

        <!-- Icomoon Font Icons css -->
        <link rel="stylesheet" href="{{asset('fonts/style.css')}}">

        <!-- Main css -->
        <link rel="stylesheet" href="{{asset('css/main.css')}}">

        <!-- fontAwesome -->
        <link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">


        <!-- Data Tables -->
        <link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4.css')}}" />
        <link rel="stylesheet" href="{{asset('vendor/datatables/dataTables.bs4-custom.css')}}" />
        <link href="{{asset('vendor/datatables/buttons.bs.css')}}" rel="stylesheet" />

		<!-- Sweet Alert-->
		<link href="{{asset('libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />


        <script src="{{asset('js/ajax.min.js')}}"></script>

        <!-- *************
            ************ Vendor Css Files *************
        ************ -->

        <!-- Bootstrap Select CSS -->
        <link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />

        <!-- Mega Menu -->
        <link rel="stylesheet" href="{{asset('vendor/megamenu/css/megamenu.css')}}">

        <!-- Search Filter JS -->
        <link rel="stylesheet" href="{{asset('vendor/search-filter/search-filter.css')}}">
        <link rel="stylesheet" href="{{asset('vendor/search-filter/custom-search-filter.css')}}">


		
	</head>

<body onload="window.print();">

<div class="card-body">
<div class="invoice-container">
    <div class="invoice-header">
        <!-- Row start -->
        <div class="row justify-content-between">
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <a href="#" class="logo">
                    <img src="/img/{{$app->app_logo}}" alt="Logo" style="max-width:120px;">
                </a>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-12">
                <address class="text-right">
                    Printed by: {{auth()->user()->name}} <br>
                    Printed Date:  <?=@strtoupper(date('Y-m-d h:i:s a')) ?><br>
                </address>
            </div>
        </div>
        <!-- Row end -->
    </div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="invoice-details">
                <address class="m-0">
                    <strong>{{$app->app_name}}</strong>,<br>
                    <?= @strtoupper("SALES TRANSACTION - [ITEM WISE: Detailed Transactions]") ?><br>
                    REPORT ON SALES FROM: <?= Auth::check() ? "ALL BRANCHES" : @strtoupper(auth()->user()->name);?>
                </address>

                <div class="invoice-num">
                    <div>Report Date</div>
                    <div> {{request()->date == null ? $dayClose->day_close : request()->date}}</div>
                </div>
            </div>
        </div>
    </div>
    <!-- Row end -->

    <div class="table-responsive">
	<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
            <th>#Tran. ID</th>
            <th>Date</th>
            <th>Item</th>
            <th>Category</th>
            <th>Quantity</th>												
            <th>Unit Price</th>
            <th>Total Price</th>
            
        </tr>
    </thead>
    <tbody>
        @foreach($all_sales as $list)
        <tr>
            <td><strong> <a href="{{route('orderTransaction',$list->invoice_number)}}">#{{$list->invoice_number}}</a></strong></td>
            <td>{{$list->created_at}}</td>
            <td>{{$list->invoice_product_name}}</td>
            <td>{{$list->invoice_category}}</td>
            <td>{{$list->invoice_quantity}}</td>
            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_unit_price)</td>
            <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($list->invoice_total_price)</td>
        </tr>
        @endforeach
    </tbody>
	</table>
</div>

</div>
</div>
</div>



		<!-- *************
			************ Required JavaScript Files *************
		************* -->
		<!-- Required jQuery first, then Bootstrap Bundle JS -->
		<script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

		<!-- *************
			************ Vendor Js Files *************
		************* -->

		<!-- Sweet Alerts js -->
		<script src="{{asset('libs/sweetalert2/sweetalert2.min.js')}}"></script>
		
		<!-- Megamenu JS -->
		<script src="{{asset('vendor/megamenu/js/megamenu.js')}}"></script>
		<script src="{{asset('vendor/megamenu/js/custom.js')}}"></script>

		<!-- Slimscroll JS -->
		<script src="{{asset('vendor/slimscroll/slimscroll.min.js')}}"></script>
		<script src="{{asset('vendor/slimscroll/custom-scrollbar.js')}}"></script>

		<!-- Search Filter JS -->
		<script src="{{asset('vendor/search-filter/search-filter.js')}}"></script>
		<script src="{{asset('vendor/search-filter/custom-search-filter.js')}}"></script>

		<!-- Apex Charts -->
		<script src="{{asset('vendor/apex/apexcharts.min.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/salesGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/ordersGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/earningsGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/visitorsGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/customersGraph.js')}}"></script>
		<script src="{{asset('vendor/apex/custom/home/sparkline.js')}}"></script>

		<!-- Circleful Charts -->
		<script src="{{asset('vendor/circliful/circliful.min.js')}}"></script>
		<script src="{{asset('vendor/circliful/circliful.custom.js')}}"></script>


		<!-- Bootstrap Select JS -->
		<script src="{{asset('vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('vendor/bs-select/bs-select-custom.js')}}"></script>


		<!-- Data Tables -->
		<script src="{{asset('vendor/datatables/dataTables.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/dataTables.bootstrap.min.js')}}"></script>
		
		<!-- Custom Data tables -->
		<script src="{{asset('vendor/datatables/custom/custom-datatables.js')}}"></script>

		<!-- Download / CSV / Copy / Print -->
		<script src="{{asset('vendor/datatables/buttons.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/jszip.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/pdfmake.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/vfs_fonts.js')}}"></script>
		<script src="{{asset('vendor/datatables/html5.min.js')}}"></script>
		<script src="{{asset('vendor/datatables/buttons.print.min.js')}}"></script>

		<!-- Dropzone JS -->
		<script src="{{asset('vendor/dropzone/dropzone.min.js')}}"></script>

		<!-- Date Range JS -->
		<script src="{{asset('vendor/daterange/daterange.js')}}"></script>
		<script src="{{asset('vendor/daterange/custom-daterange.js')}}"></script>

		<!-- Main Js Required -->
		<script src="{{asset('js/main.js')}}"></script>

	</body>

</html>
