@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Product Information</div>
                </div>
                <div class="card-body">
                <ul class="customer-rating">
                    <li class="clearfix">
                        <div class="customer">
                            <img src="/uploads/{{empty($product->product_image) ? 'no-product.png' : $product->product_image}}" alt="product">
                        </div>
                        <?php $user_cre = \DB::table('users')->where('id', $product->user_id)->first(); ?>
                        <div class="customer-review">
                            <div class="stars" id="rate2"></div>
                            <h5>{{$product->invoice_product_name}}</h5>
                            <h6 class="by">By, <a href="#">{{$user_cre->name}}</a></h6>
                            <p>Transaction: {{$product->invoice_number}}</p>
                            <p>Outlet: {{$product->branch}}</p>
                            <p>Quantity: @convert($product->invoice_quantity)</p>
                        </div>
                    </li>
                </ul>
                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Item BOM</div>
                </div>
                <div class="card-body">
                <div class="table-responsive">
                <table class="table table-bordered v-middle m-0">
                            <thead>
                                <tr>
                                    <th>Item Name</th>
                                    <th>Unit</th>
                                    <th>Cost</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            @foreach($p_comp as $comp)
                            <tr>
                                <td>{{$comp->product_name}}</td>
                                <td>{{(float)$comp->unit_measure * $product->invoice_quantity}}</td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($comp->cost * $product->invoice_quantity)</td>
                                <td>
                                    <form action="{{route('ReverseProductComposition')}}" method="get">
                                        <input type="text" name="quantity" hidden value="{{$product->invoice_quantity * $comp->unit_measure}}">
                                        <input type="text" name="comp_id" hidden value="{{$comp->composition_id}}">
                                        <input type="text" name="branch" hidden value="{{$product->branch}}">
                                        <input type="text" name="product_id" hidden value="{{$product->product_id}}">
                                        <input type="text" name="date" hidden value="{{$product->created_at}}">
                                        <input type="submit" class="btn btn-outline-primary rounded-pill rounded btn-sm" name="type" value="Returned Item">
                                    </form>

                                    <form action="{{route('ReverseProductComposition')}}" method="get">
                                        <input type="text" name="quantity" hidden value="{{$product->invoice_quantity * $comp->unit_measure}}">
                                        <input type="text" name="comp_id" hidden value="{{$comp->composition_id}}">
                                        <input type="text" name="product_id" hidden value="{{$product->product_id}}">
                                        <input type="text" name="branch" hidden value="{{$product->branch}}">
                                        <input type="text" name="date" hidden value="{{$product->created_at}}">
                                        <input type="submit" class="btn btn-outline-primary rounded-pill rounded btn-sm mt-2" value="Wastage" name="type">  
                                    </form>

                                    <form action="{{route('ReverseProductComposition')}}" method="get">
                                        <input type="text" name="quantity" hidden value="{{$product->invoice_quantity * $comp->unit_measure}}">
                                        <input type="text" name="comp_id" hidden value="{{$comp->composition_id}}">
                                        <input type="text" name="product_id" hidden value="{{$product->product_id}}">
                                        <input type="text" name="branch" hidden value="{{$product->branch}}">
                                        <input type="text" name="date" hidden value="{{$product->created_at}}">
                                        <input type="submit" class="btn btn-outline-primary rounded-pill rounded btn-sm mt-2" value="Restore BOM" name="type">  
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                    </table>
                </div>
                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->





@endsection