@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
@if(empty(session()->get('discount')) || null)
@if(!empty($cartItems))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
HELLO {{@strtoupper(auth()->user()->name)}}! YOU DID NOT COMPLETE YOUR LAST TRANSACTION. COMPLETE INVOICE OR <a href="{{route('deleteDump')}}">REGENRATE CREATE NEW INVOICE</a>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@else
@endif
@endif

<div style="padding:15px" class="card">
 <!-- Field wrapper start -->
 <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" placeholder="Click Here And Scan Bar Code" type="text" autofocus id="barcode" onchange="getBarcode()">
                <span class="input-group-text">
                    <button class="btn btn-primary btn-sm" type="button" onClick=" autofocusBarcode()">
                        <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                        Enable Scan
                    </button>
                </span>
            </div>
            <div class="field-placeholder">Scan Barcode</div>
        </div>
        <!-- Field wrapper end -->
<form id="newinvoice">
    @csrf
<!-- Row start -->
<div class="row gutters">
    
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
        <div class="form-section-header">New Invoice</div>

    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
     <!-- Field wrapper start -->
     <div class="field-wrapper">
            <select name="invoice_product_name" class="select-single js-states" title="Select Product Category"  onchange="getPrice()" id="ddlViewBy" data-live-search="true">
            <option selected disabled>Select Item</option>
                    @foreach($products as $product)
                            <option value="{{$product->FinalProductionID}}">{!!$product->Name!!}</option>
                    @endforeach
            </select>
            <div class="field-placeholder">Product Name</div>
        </div>
        <!-- Field wrapper end -->
        
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" type="text" value="1" id="quantity" name="invoice_quantity" onKeyUp="calculateTotal()">
                <span class="input-group-text">
                <i class="fa fa-calculator" aria-hidden="true"></i>
                </span>
            </div>
            <div class="field-placeholder">Quantity</div>
        </div>
        <!-- Field wrapper end -->

    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" readonly step="0.01" type="number" id="price" name="invoice_unit_price">
                <span class="input-group-text">
                    {{empty($app->currency) ? "GHS" : $app->currency}}
                </span>
            </div>
            <div class="field-placeholder">Price</div>
        </div>
        <!-- Field wrapper end -->

    </div>

    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" readonly id="total" type="text" name="invoice_total_price">
                <span class="input-group-text">
                {{empty($app->currency) ? "GHS" : $app->currency}}
                </span>
            </div>
            <div class="field-placeholder">Total Price</div>
        </div>
        <!-- Field wrapper end -->

    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <select name="status" onchange="getValue()" id="getStatus" class="select-single js-states" title="Select Product Category">
                    <option value="General">General</option>
                    <option value="On The House" id="On The House">On The House</option>
                </select>
            </div>
            <div class="field-placeholder">Order Type</div>
        </div>
        <!-- Field wrapper end -->

    </div>

    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" readonly value="{{auth()->user()->branch}}" type="text" >
            </div>
            <div class="field-placeholder">Placing Order to</div>
        </div>
        <!-- Field wrapper end -->

    </div>
    
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

    <input type="text" value="" readonly name="category" id="category" hidden>

    </div>
    @if(auth()->user()->sales_person_category == "Delivery")
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <button class="btn btn-outline-primary rounded-pill stripes-btn"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
    </div>
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" style="float:right">
     <button class="btn btn-outline-primary rounded-pill stripes-btn" type="button"><i class="fa fa-motorcycle" aria-hidden="true"></i> Add Delivery</button>
    </div>
    @else
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <button class="btn btn-outline-primary rounded-pill stripes-btn" ><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
    </div>
    @endif
    
</div>
<!-- Row end -->
</form>
</div>

<div id="tabler">
@if(empty($checkseesion))
    <!-- Card start -->
    <div class="card">
        <div class="card-body">
            <div class="alert alert-primary alert-dismissible fade show" role="alert">
                    No Item added to cart. Kindly select Item and add to cart
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            
        </div>
    </div>
    <!-- Card end -->
    @else  
                         
<table class="table table-bordered table-striped m-0">
    <thead>
        <tr>
            <th colspan="7" class="pt-3 pb-3">Invoice Details</th>
        </tr>
        <tr>
            <th width="50%">Product</th>
            <th width="20%">Category</th>
            <th width="50%">Quantity</th>
            <th width="20%">Price</th>
            <th width="30%">Amount (Net)</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    @foreach($cartItems as $key => $cart)
        <tr>
            <td><select class="form-control"><option>{!!@strtoupper($cart['invoice_product_name'])!!}</option></select></td>
           <td><input type="text" value="{{@strtoupper($cart['item_category'])}}" class="form-control" readonly></td>
            <td>
                    <div class="input-group">
                        <span class="input-group-text"><a href="javascript:void(0)" id="{{$cart['id']}}" onclick="decrease(id)" class="plus-btn text-black"><i class="icon-minus"></i></a></span>
                        <input class="form-control" type="text" id="qty{{$cart['id']}}" id="qty{{$cart['id']}}" class="form-control" value="{{$cart['invoice_quantity']}}">
                        <span class="input-group-text"><a href="javascript:void(0)" id="{{$cart['id']}}" onclick="increase(id)" class="plus-btn text-black"><i class="icon-plus1"></i></a></span>
                    </div>
                
            </td>
            <td>
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <input type="text" readonly class="form-control" value="@convert($cart['invoice_unit_price'])" id="ItemPrice{{$cart['id']}}">
                </div>
                <!-- Field wrapper end -->
            </td>
            <td>
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <input type="text" readonly class="form-control" value="{{empty($app->currency) ? "GHS" : $app->currency}}@convert($cart['invoice_total_price'])">
                </div>
                <!-- Field wrapper end -->
            </td>
            
            <td>
                <div class="table-actions">
                    <button class="btn btn-light" id="{{$cart['id']}}" onClick="DeleteItem(this.id)">
                        <i class="icon-trash-2"></i>
                    </button>
                </div>
            </td>
        </tr>
        @endforeach
        <tr>
            <td colspan="6">
                <div class="row gutters justify-content-end">
                    <div class="col-auto">
                        <label class="col-form-label">Discount % / {{empty($app->currency) ? "GHS" : $app->currency}} of Total Amount</label>
                    </div>
                    <div class="col-auto" style="max-width: 90px;">
                        <!-- Discount Button trigger modal -->
                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalSmall">
                            % Add Discount
                        </button>
                    </div>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="4">&nbsp;</td>
            <td colspan="2">
                <p class="m-0">Subtotal</p>
                <p class="m-0">Discount</p>
                <p class="m-0">VAT</p>
                <h5 class="mt-2">Total Amount</h5>
            </td>
            <td>
                <p class="m-0">@convert(empty($checkseesion) ? 0 : $totalCart)</p>
                <p class="m-0" id="discounting">
                    <?php
                        if (empty(session()->get('discount'))) {
                            echo empty($app->currency) ? "GHS" : $app->currency . "0,00";
                        }else {
                           if (session()->get('discount')['type'] == "Cash") {
                            echo empty($app->currency) ? "GHS" : $app->currency . session()->get('discount')['discount'];
                           }elseif (session()->get('discount')['type']== "Percentage") {
                            echo  session()->get('discount')['discount'] . "%";
                          }
                        }

                    ?>
                </p>
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}0.00</p>
                @if(empty(session()->get('discount')))
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(empty($checkseesion) ? 0 : $totalCart)</h5>
                @else
                @if(session()->get('discount')['type'] == "Percentage")
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart * ((100 - session()->get('discount')['discount']))/100)</h5>
                @else
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart - session()->get('discount')['discount'] )</h5>
                @endif
                @endif
            </td>
        </tr>
    </tbody>
</table>
@endif
</div>

<!-- Row start -->
<div class="row gutters">

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <div class="form-actions-footer">
        <div class="text-end">
            <!-- Discount Button trigger modal -->
            <button type="button"  class="btn btn-outline-success ms-1" data-bs-toggle="modal" data-bs-target="#exampleModalSmallceleb">
                Discount Code
            </button>
            <a href="#" class="btn btn-outline-secondary ms-1" data-bs-toggle="modal" data-bs-target="#staticBackdropTingging">Accept Payment</a>
            <a href="#" onclick="confirmCreateNew()" class="btn btn-outline-primary ms-1">New Invoice</a>
             <button class="btn btn-outline-primary ms-1" onclick="saveDraft()">Save Draft</button>
             <a href="#" onclick="getInvoiceNumber()"  class="btn btn-outline-info ms-1" data-bs-toggle="modal" data-bs-target="#Table">Assign Table</a>
        </div>
    </div>
</div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->



<!-- Modal start -->
<div class="modal fade" id="exampleModalSmall" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-center">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">APPLY COUPON</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="dis">
            @if(empty($cartItems) || null)
            @else
            <form action="{{route('OrderDiscount')}}" method="POST" id="discountAmount">
                @csrf
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                    <select name="type" class="form-control">
                        <option value="Percentage">PERCENTAGE</option>
                        <option value="Cash">CASH</option>
                    </select>
                        <div class="field-placeholder">Type <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" type="number" step="0.01" name="discount" required>
                        <div class="field-placeholder">Amount or % <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                
                <button type="submit" class="btn btn-outline-primary">Apply</button>
            </form>
            @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->




<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallceleb" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">COUPON CODE</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="disinf" >
            @if(empty($cartItems) || null)
            @else
            <form action="{{route('OrderDiscount')}}" method="POST">
                @csrf
                <input type="text" name="type" value="Percentage" hidden>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" placeholder="enter coupon code" type="text" name="discount_code">
                        <div class="field-placeholder">Coupon code<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <input  type="submit" name="submit_celeb" id="" value="Apply Code" class="btn btn-outline-primary">
            </form>
            @endif
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<?php $all_tables = \DB::table('register_tables')->pluck('table_name') ?>
<?php $waiter = \DB::table('users')->where('role','waiter')->pluck('name') ?>
<!-- Table Modal start -->
<div class="modal fade" id="Table" tabindex="-1" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">ASSIGN ORDER TO A TABLE</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form action="{{route('generateInvoiceBar')}}" method="post">
            @csrf            

                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <select class="select-single js-states" name="table_name" title="Select Product Category" data-live-search="true">
                            <option disabled selected>Select Table</option>
                            @foreach($all_tables as $tb)
                            <option>{{$tb}}</option>
                            @endforeach
                        </select>
                        <div class="field-placeholder">Select Table</div>
                    </div>
                    <!-- Field wrapper end -->

                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                            <select class="select-single js-states" name="table_served_by" title="Select Product Category" data-live-search="true">
                                <option disabled selected>Select waiter</option>
                                @foreach($waiter as $tb)
                                <option>{{$tb}}</option>
                                @endforeach
                            </select>
                               
                            </div>
                            <div class="field-placeholder">Served By <span class="text-danger"></span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="checkbox-container">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="table_settlement" value="1">
                                    <label class="form-check-label">Settled</label>
                                </div>
                                <div class="field-placeholder">Payment</div>
                            </div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <button class="btn btn-primary">Generate Receipt</button>
                    </div>
                </div>
                <!-- Row end -->
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
<!-- Modal end -->






    <!-- Modal on the house start -->
    <div class="modal fade" id="onthehouse" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalSmallTitle">No Charge Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                @include('inc.onhouse')
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal end -->


     <!-- Tingg Modal -->
     @include('tingg.invoice-payment-modal')

</div>
<!-- Content wrapper scroll end -->



<script type="text/javascript">
    
    $("#newinvoice").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('InvoiceDump')}}",
                dataType: "json",
                data: $('#newinvoice').serialize(),
                success: function(data){
                    document.getElementById('price').value = "";
                    document.getElementById('total').value = "";
                    document.getElementById('quantity').value = "1";
                    document.getElementById('ddlViewBy').value = "";
                    $("#tabler").load(" #tabler");

                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


        $("#discount").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('OrderDiscount')}}",
                dataType: "json",
                data: $('#discount').serialize(),
                success: function(data){
                    $("#tabler").load(" #tabler");
                    $("#dis").load(" #dis");
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        



        function calculateTotal() {
            quantity = document.getElementById("quantity").value;
            price = document.getElementById("price").value;
            // document.getElementById("result").innerHTML = num1 * num2;
            document.getElementById("total").value = quantity*price;
        }


        function saveDraft() {

            Swal.fire({
            title: 'Are you sure?',
            text: "This Invoice will be saved as Draft Invoice!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save as Draft!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#tabler").load(" #tabler");
                    Swal.fire(
                        'Saved to Draft!',
                        'This Invoice is Saved as Draft',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/generate-draft-invoice");
                xhttp.send();
            }
            })
            
        }


        function DeleteItem(id) {
        $(this).closest('tr').remove();
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/ceqafoods/delete-item/"+id);
            xhttp.send();
            
        }



        function increase(id) {
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            var total = quantity * price;
            console.log(total);

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#tabler").load(" #tabler");
                $("#dis").load(" #dis");

            }
            xhttp.open("GET", "/increase-cart/"+id + "/" + quantity);
            xhttp.send();
        }


        function decrease(id) {
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            var total = quantity * price;

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#tabler").load(" #tabler");
                $("#dis").load(" #dis");

            }
            xhttp.open("GET", "/decrease-cart/"+id + "/" + quantity);
            xhttp.send();
        }

        function confirmInvoice() {
            Swal.fire({
                title: 'Generate Receipt, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Save And Print Receipt!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('generateInvoice')}}"
                }
                })
        }

        function getPrice() {
            var e = document.getElementById("ddlViewBy");
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $da = JSON.parse(this.responseText);
                document.getElementById("price").value = $da.price;
                document.getElementById("category").value = $da.category;
                quantity = document.getElementById("quantity").value;
                price = document.getElementById("price").value;
                document.getElementById("total").value = quantity*price;
            }
            xhttp.open("GET", "/get-product-price/"+e.value);
            xhttp.send();
            
        }

        function confirmCreateNew() {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, create New Invoice!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('deleteDump')}}";
                }
                })
        }



        function autofocusBarcode(){
            document.getElementById('barcode').focus();
        }


        function getBarcode(){
            
            var barcode = document.getElementById('barcode').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                if (this.responseText === "empty") {
                    document.getElementById('barcode').value = "";

                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong! There May be no matching Item to scanned Product',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })

                }else{

                    document.getElementById('barcode').value = "";

                    $("#tabler").load(" #tabler");

                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                }
            }
            xhttp.open("GET", "/barcode-search/"+barcode);
            xhttp.send();
        }


        function getValue() {
            var e = document.getElementById("getStatus");
            if (e.value === "On The House") {
                $('#onthehouse').modal('show')
            }else{
                console.log("error")
            }
        }
</script>


@endsection