@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
@if(empty(session()->get('discount')) || null)
@if(!empty($cartItems))
<div class="alert alert-danger alert-dismissible fade show" role="alert">
HELLO {{@strtoupper(auth()->user()->name)}}! YOU DID NOT COMPLETE YOUR LAST TRANSACTION. COMPLETE INVOICE OR <a href="{{route('deleteDump')}}">REGENRATE CREATE NEW INVOICE</a>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@else
@endif
@endif
        <div class="row gutters mb-3">
            <div class="col-sm-4">
                
            <div class="input-group">
                    <input class="form-control" placeholder="Customer Name" value="{{!empty(session()->get('customer_name')) ? session()->get('customer_name') : ''}}" id="CustomerName" onChange="CustomerName()" required type="text" name="customer_name">
                    <span class="input-group-text">
                    <i class="icon-user1"></i>
                    </span>
                    
                </div>
            </div>
            <div class="col-sm-4">
            <div class="input-group">
                    <input class="form-control" placeholder="Customer Address" value="{{!empty(session()->get('customer_name')) ? session()->get('customer_address') : ''}}" id="CustomerAddress" onChange="CustomerAddress()" id="CustomerAddress" onChange="CustomerAddress()" type="text" name="customer_location">
                    <span class="input-group-text">
                    <i class="icon-map-pin"></i>
                    </span>
                </div>
            </div>
            <div class="col-sm-4">
            <div class="input-group">
                    <input class="form-control" required value="{{!empty(session()->get('customer_name')) ? session()->get('customer_contact') : ''}}" id="CustomerContact" onChange="CustomerContact()" name="customer_phone"  placeholder="0123456789"  type="tel" pattern="[0-9]{4}[0-9]{4}[0-9]{2}">
                    <span class="input-group-text">
                        <i class="icon-phone"></i>
                    </span>
                </div>
            </div>

        </div>


<div style="padding:15px" class="card">
@if(auth()->user()->sales_person_category == "Counter")
    <!-- Field wrapper start -->
    <div class="field-wrapper">
        <div class="input-group">
            <input class="form-control" placeholder="Click Here, Scan Bar Code Or search by Item Code" type="text" autofocus autocomplete="off" id="barcode" onchange="getBarcode()">
            <span class="input-group-text">
                <button class="btn btn-primary btn-sm" type="button" onClick="autofocusBarcode()">
                    <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                    Enable Scan
                </button>
            </span>
        </div>
        <div class="field-placeholder">Scan Barcode</div>
    </div>
    <!-- Field wrapper end -->
@endif
<form id="newinvoice">
    @csrf
<!-- Row start -->
<div class="row gutters">
    
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-4 col-12">
        <div class="form-section-header">New Invoice<span style="float:right" class="badge bg-info">{{auth()->user()->branch}}</span></div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
    	<!-- Field wrapper start -->
        <div class="field-wrapper">
            <select name="invoice_product_name" class="select-single js-states" title="Select Product Category" id="ddlViewBy" data-live-search="true">
            <option selected disabled>Select Item</option>
            @foreach($products as $product)
                    <option value="{{$product->FinalProductionID}}" 
                    <?php
                        if (empty($product->activated_branches)) {
                            echo '';
                        }else {
                            echo in_array(auth()->user()->branch, json_decode($product->activated_branches)) == true ? 'disabled' : '';
                        }
                        ?>>
                        [{{empty($app->currency) ? "GHS" : $app->currency}}{!!@strtoupper($product->UnitPrice)!!}]  {!!@strtoupper($product->Name)!!}
                    </option>
            @endforeach
            </select>
            <div class="field-placeholder">Product Name</div>
        </div>
        <!-- Field wrapper end -->
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <input class="form-control" type="text" value="1" id="quantity" name="invoice_quantity" onKeyUp="calculateTotal()">
                <span class="input-group-text">
                <i class="fa fa-calculator" aria-hidden="true"></i>
                </span>
            </div>
            <div class="field-placeholder">Quantity</div>
        </div>
        <!-- Field wrapper end -->

    </div>

    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        
        <!-- Field wrapper start -->
        <div class="field-wrapper">
            <div class="input-group">
                <select name="status" onchange="getValue()" id="getStatus" class="select-single js-states">
                    <option value="General">General</option>
                </select>
            </div>
            <div class="field-placeholder">Order Type</div>
        </div>
        <!-- Field wrapper end -->

    </div>

    
    @if(Route::currentRouteName() == "indexAgency")
    <input type="text" value="{{$agencying}}" name="agency" readonly hidden>
    @endif
    
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

    <input type="text" value="" readonly name="category" id="category" hidden>

    </div>
    @if(auth()->user()->sales_person_category == "Delivery")
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <button class="btn btn-outline-primary rounded-pill"><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
        <button class="btn btn-outline-primary rounded-pill" style="margin-left:30px" onclick="getDeliveryValue()" type="button" data-bs-toggle="modal" data-bs-target="#exampleModalExtraLarge">
        <i class="icon-directions_car" aria-hidden="true"></i> Dispatch Fee</button>
    </div>
    @else
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        <button class="btn btn-outline-primary rounded-pill" ><i class="icon-shopping-cart1" aria-hidden="true"></i> Add to Cart</button> 
    </div>
    @endif

    
</div>
<!-- Row end -->
</form>
</div>


<div id="tabler">
@if(empty($checkseesion))
    <!-- Card start -->
    <div class="card">
        <div class="card-body">
            <div class="alert alert-primary alert-dismissible fade show" role="alert">
                    No Item added to cart. Kindly select Item and add to cart {{auth()->user()->sales_person_category == "Counter" ? "or use Barcode" : ""}}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            
        </div>
    </div>
    <!-- Card end -->
    @else 
                         
<table class="table table-bordered table-striped table-sm">
    <thead>
        <tr>
            <th colspan="7" class="pt-3 pb-3">Invoice Details</th>
        </tr>
        <tr>
        <th width="45%">Product</th>
            <th width="20%">Category</th>
            <th width="50%">Quantity</th>
            <th width="20%">Price</th>
            <th width="20%">Amount (Net)</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    @foreach($cartItems as $key => $cart)
    <tr class="trhidden{{$cart['id']}}">
            <td><select class="form-control"><option>{!!@strtoupper($cart['invoice_product_name'])!!}</option></select></td>
           <td><input type="text" value="{{@strtoupper($cart['item_category'])}}" class="form-control" readonly></td>
            <td>
            <div class="input-group">
                    <div class="d-flex mb-4" style="max-width: 300px">
                            <button class="btn btn-light btn-sm" id="{{$cart['id']}}" onclick="decrease(id)">
                            <i class="icon-minus"></i>
                            </button>
        
                            <div class="form-outline">
                            <input min="1" readonly type="number" id="qty{{$cart['id']}}" id="qty{{$cart['id']}}" value="{{$cart['invoice_quantity']}}" name="quantity"  class="form-control" />
                            </div>
        
                            <button class="btn btn-light btn-sm" id="{{$cart['id']}}" onclick="increase(id)">
                            <i class="icon-plus1"></i>
                            </button>
                    </div>
                    <!-- Quantity -->
                </div>
            </td>
            <td>
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <input type="text" readonly class="form-control" value="@convert($cart['invoice_unit_price'])" id="ItemPrice{{$cart['id']}}">
                </div>
                <!-- Field wrapper end -->
            </td>
            <td>
                <!-- Field wrapper start -->
                <div class="field-wrapper m-0">
                    <input type="text" id="demo{{$cart['id']}}" readonly class="form-control" value="{{empty($app->currency) ? "GHS" : $app->currency}}@convert($cart['invoice_unit_price'] * $cart['invoice_quantity'])">
                </div>
                <!-- Field wrapper end -->
            </td>
            
            <td>
                <div class="table-actions">
                    <button class="btn btn-light" id="{{$cart['id']}}" onClick="DeleteItem(this.id)">
                        <i class="icon-trash-2"></i>
                    </button>
                </div>
            </td>
        </tr>
        @endforeach
        <tr>
            <td colspan="6">
                <div class="row gutters justify-content-end">
                    <div class="col-auto">
                        <label class="col-form-label">Discount % / {{empty($app->currency) ? "GHS" : $app->currency}} of Total Amount</label>
                    </div>
                    <div class="col-auto" style="max-width: 90px;">
                        <!-- Discount Button trigger modal -->
                        <button type="button" class="btn btn-primary mb-2" data-bs-toggle="modal" data-bs-target="#exampleModalSmall">
                            % Add Discount
                        </button>
                    </div>
                </div>
            </td>
        </tr>
        <tr>
            <td colspan="4">&nbsp;
            <div class="col-12">
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <textarea class="form-control" rows="3" onChange="editNote()" placeholder="Add Note" id="noteText">{{!empty(session()->get('customer_note')) ? session()->get('customer_note') : ''}}</textarea>
                        <div class="field-placeholder">Note</div>
                    </div>
                    <!-- Field wrapper end -->
                </div>
            </td>
            <td colspan="2">
                <p class="m-0">Subtotal</p>
                <p class="m-0">Discount</p>
                <p class="m-0">VAT</p>
                <h5 class="mt-2">Total Amount</h5>
            </td>
            <td>
            <div id="subtotals">
                <p class="m-0">@convert(empty($checkseesion) ? 0 : $totalCart)</p>
                <p class="m-0" id="discounting">
                    <?php
                        if (empty(session()->get('discount'))) {
                            echo empty($app->currency) ? "GHS" : $app->currency . "0,00";
                        }else {
                           if (session()->get('discount')['type'] == "Cash") {
                            echo empty($app->currency) ? "GHS" : $app->currency . session()->get('discount')['discount'];
                           }elseif (session()->get('discount')['type']== "Percentage") {
                            echo  session()->get('discount')['discount'] . "%";
                          }
                        }

                    ?>
                </p>
                <p class="m-0">{{empty($app->currency) ? "GHS" : $app->currency}}0.00</p>
                @if(empty(session()->get('discount')))
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(empty($checkseesion) ? 0 : $totalCart)</h5>
                @else
                @if(session()->get('discount')['type'] == "Percentage")
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart * ((100 - session()->get('discount')['discount']))/100)</h5>
                @else
                <h5 class="mt-2" id="tcost">{{empty($app->currency) ? "GHS" : $app->currency}} @convert( $totalCart - session()->get('discount')['discount'] )</h5>
                @endif
                @endif
                </div>
            </td>
            
        </tr>
    </tbody>
</table>
@endif



<!-- Row start -->
<div class="row gutters">

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
    <div class="form-actions-footer">
        <div class="text-end">
            <!-- Discount Button trigger modal -->
            <button type="button" class="btn btn-outline-success ms-1" data-bs-toggle="modal" data-bs-target="#exampleModalSmallceleb">
               <i class="icon-gift"></i> Gift Cards
            </button>
        <a href="#" class="btn btn-outline-secondary stripes-btn" data-bs-toggle="modal" data-bs-target="#staticBackdropTingging"><i class="icon-attach_money"></i>Accept Payment</a>
        <a href="#" onclick="confirmCreateNew()" class="btn btn-outline-dark ms-1"><i class="icon-pause1"></i> New Invoice</a>
        <button class="btn btn-outline-primary ms-1" onclick="saveDraft(this.id)"><i class="icon-drafts"></i> Save Draft</button>
        @if($bar == 1)
        <a href="#" class="btn btn-outline-info ms-1" data-bs-toggle="modal" data-bs-target="#Table">Assign Table</a>
        @else
        <a href="#" onclick="newInvoiceConfirm(this.id)" class="btn btn-outline-info ms-1"> <i class="icon-receipt"></i>Place Order</a>
        @endif
        </div>
    </div>
</div>

</div>
<!-- Row end -->

</div>
<!-- Content wrapper end -->


    <!-- Modal on the house start -->
    <div class="modal fade" id="onthehouse" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalSmallTitle">On the House Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                @include('inc.onhouse')
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal end -->



<!-- Modal start -->
<div class="modal fade" id="exampleModalSmall" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-center">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">APPLY COUPON</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="dis">
            <form id="discountAmount">
                @csrf
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                    <select name="type" class="select-single js-states">
                        <option value="Percentage">PERCENTAGE</option>
                        <option value="Cash">CASH</option>
                    </select>
                        <div class="field-placeholder">Type <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" type="number" step="0.01" name="discount" required>
                        <div class="field-placeholder">Amount or % <span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                
                <button type="submit" class="btn btn-outline-primary">Apply</button>
            </form>
           
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="cancelCoupon">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->

<!-- Modal start -->
<div class="modal fade" id="exampleModalSmallceleb" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">COUPON CODE OR GIFT CARD</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="disinf" >
           
            <form id="discountAmountCoupon">
                @csrf
                <input type="text" name="type" value="Percentage" hidden>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <input  type="text" name="submit_celeb" hidden value="Apply Code">

												
                    <!-- Field wrapper start -->
                    <div class="field-wrapper">
                        <input class="form-control" placeholder="Coupon Code Or Scan Gift Card" type="text" autocomplete="off" name="discount_code">
                        <div class="field-placeholder">Coupon code<span class="text-danger">*</span></div>
                    </div>
                    <!-- Field wrapper end -->

                </div>
                <input  type="submit" name="submit_celeb" id="" value="Apply Code" class="btn btn-outline-primary">
            </form>
            
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancelgift" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->


    <!-- delivery Modal -->
    @include('inc.delivery')
    
     <!-- Tingg Modal -->
     @include('tingg.invoice-payment-modal')


</div>
<!-- Content wrapper scroll end -->


<!-- Table Modal start -->
<div class="modal fade" id="Table" tabindex="-1" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">ASSIGN ORDER TO A TABLE</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form action="{{route('generateInvoiceBar')}}" method="post">
            @csrf
                <!-- Row start -->
                <div class="row gutters">
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input class="form-control" type="text" name="table_name">
                                <span class="input-group-text">
                                    <i class="icon-user1"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Table Name <span class="text-danger">*</span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="input-group">
                                <input class="form-control" type="text" name="table_served_by">
                                <span class="input-group-text">
                                    <i class="icon-email"></i>
                                </span>
                            </div>
                            <div class="field-placeholder">Served By <span class="text-danger"></span></div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

                        <!-- Field wrapper start -->
                        <div class="field-wrapper">
                            <div class="checkbox-container">
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input" type="checkbox" name="table_settlement" value="1">
                                    <label class="form-check-label">Settled</label>
                                </div>
                                <div class="field-placeholder">Payment</div>
                            </div>
                        </div>
                        <!-- Field wrapper end -->

                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        <button class="btn btn-primary">Submit</button>
                    </div>
                </div>
                <!-- Row end -->
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
        </div>
    </div>
    </div>
<!-- Modal end -->


<script type="text/javascript">
    
    $("#newinvoice").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('InvoiceDumpCall')}}",
                dataType: "json",
                data: $('#newinvoice').serialize(),
                success: function(data){
                    document.getElementById('quantity').value = "1";
                    // RELOAD TABLE
                    $("#tabler").load(" #tabler");

                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });

        
    $("#discountAmount").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('OrderDiscount')}}",
                dataType: "json",
                data: $('#discountAmount').serialize(),
                success: function(data){
                    $("#subtotals").load(" #subtotals");
                    document.getElementById('cancelCoupon').click();
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Discount Applied to Order'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });

        $("#discountAmountCoupon").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('OrderDiscount')}}",
                dataType: "json",
                data: $('#discountAmountCoupon').serialize(),
                success: function(data){
                    $("#subtotals").load(" #subtotals");
                    document.getElementById('cancelgift').click();
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'bottom-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Discount Applied to Order'
                    })
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong! Mismatch Coupon Code or Gift Card',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });


        function editNote() {
            var note = document.getElementById('noteText').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-note/"+note);
            xhttp.send();
        }


        function CustomerName(){
            var name = document.getElementById('CustomerName').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-name/"+name);
            xhttp.send();
        }

        function CustomerAddress(){
            var address = document.getElementById('CustomerAddress').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-address/"+address);
            xhttp.send();
        }

        function CustomerContact(){
            var contact = document.getElementById('CustomerContact').value;
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
             
            }
            xhttp.open("GET", "/ceqa-dashboard/customer-contact/"+contact);
            xhttp.send();
        }


        

        $("#updatecustomer").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('updateCustomer')}}",
                dataType: "json",
                data: $('#updatecustomer').serialize(),
                success: function(data){
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Customer Profile updated Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function DeleteItem(id) {
            // $('.trhidden'+id).hide();
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {
                $("#tabler").load(" #tabler");
            }
            xhttp.open("GET", "/ceqafoods/delete-item/"+id);
            xhttp.send();
            
        }

        function increase(id) {
            document.getElementById('qty'+ id).stepUp()
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            // var quantity = (++quantity)
            document.getElementById('demo'+ id).value = quantity * price;

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#subtotals").load(" #subtotals");

            }
            xhttp.open("GET", "/increase-cart/"+id + "/" + quantity);
            xhttp.send();
        }


        function decrease(id) {
            document.getElementById('qty'+ id).stepDown()
            var quantity = document.getElementById('qty'+ id).value;
            var price = document.getElementById('ItemPrice'+ id).value;
            // var quantity = (++quantity)
            document.getElementById('demo'+ id).value = quantity * price;

            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                $("#subtotals").load(" #subtotals");

            }
            xhttp.open("GET", "/decrease-cart/"+id + "/" + quantity);
            xhttp.send();
        }


        function newInvoiceConfirm() {
            Swal.fire({
                title: 'Place Order, Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Place Order!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "/ceqa-dashboard/place-order/call-center";
                }
                })
        }


        function saveDraft(id) {

            Swal.fire({
            title: 'Are you sure?',
            text: "This Invoice will be saved as Draft Invoice!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Save as Draft!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#tabler").load(" #tabler");
                    Swal.fire(
                        'Saved to Draft!',
                        'This Invoice is Saved as Draft',
                        'success'
                        )
                }
                xhttp.open("GET", "/generate-draft/delivery/"+id);
                xhttp.send();
            }
            })

            }



        function calculateTotal() {
            quantity = document.getElementById("quantity").value;
            price = document.getElementById("price").value;
            // document.getElementById("result").innerHTML = num1 * num2;
            document.getElementById("total").value = quantity*price;
        }


        function getValue() {
            var invoiceinput = document.getElementById("myInput").value;
            var e = document.getElementById("getStatus");
            if (e.value === "On The House") {
                $('#onthehouse').modal('show')
                document.getElementById("inv").value = invoiceinput
            }else{
                console.log("error")
            }
        }


        function confirmCreateNew() {
            Swal.fire({
                title: 'Are you sure?',
                text: "Are you sure you want to void transaction?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, create New Invoice!'
                }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{route('deleteDump')}}";
                }
                })
        }


        
        function getBarcode(){
            
            var barcode = document.getElementById('barcode').value;
            document.getElementById('barcode').value = "";
            const xhttp = new XMLHttpRequest();
            xhttp.onload = function() {

                if (this.responseText === "empty") {
                    document.getElementById('barcode').value = "";

                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                     text: 'Something went wrong! There May be no matching Item to scanned Product',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })

                }else{

                    $("#tabler").load(" #tabler");

                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-right',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Added to Cart, add new Item'
                    })
                }
            }
            xhttp.open("GET", "/barcode-search/"+barcode);
            xhttp.send();
        }


        function autofocusBarcode(){
            document.getElementById('barcode').focus();
        }

        function getDeliveryValue() {
            var invoiceinput = document.getElementById("myInput").value;
            document.getElementById("delivery_id").value = invoiceinput
        }
</script>



@endsection