@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
        
            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">Draft Orders</div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="basicExample" class="table custom-table">
                            <thead>
                                <tr>
                                    <th>Trans. ID</th>
                                    <th>Branch</th>
                                    <th>Cost of Order</th>
                                    <th>Created At</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($drafts as $draft)
                                <tr>
                                    <td>#{{$draft->order_id}}</td>
                                    <td>{{$draft->branch}}</td>
                                    <td>{{empty($app->currency) ? "GHS" : $app->currency}} @convert($draft->total_cost_order)</td>
                                    <td>{{$draft->created_at}}</td>
                                    <td><a href="{{route('saveToDump',$draft->order_id)}}" class="btn btn-outline-primary">Create Invoice</a></td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection