@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    
                    <div class="table-responsive">
                        <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Invoice Number</th>
                                  <th>Branch</th>
                                  <th>Sales category</th>
                                  <th>Status</th>
                                  <th>Total</th>
                                  <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $order)
                                <tr>
                                    <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#">#{{$order -> order_id}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>{{$order -> branch}}</td>
                                  <td>{{$order -> category}}</td>
                                  <td>{!! $order -> status == 0 ? '<span class="badge rounded-pill bg-info">' . "Processing" . '</span>' : '<span class="badge rounded-pill bg-success">' . "Completed" . '</span>' !!}</td>
                                  <td>GH₵{{$order -> total_cost_order}}</td>
                                  <td>
                                      <div class="actions">
                                          <a href="{{route('orderTransaction', $order -> order_id)}}" data-toggle="tooltip" data-placement="top" title="" data-original-title="Edit">
                                              <i class="icon-edit1 text-info"></i>
                                          </a>
                                      </div>
                                  </td>
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>
                    {{$orders->links()}}
                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->

@endsection