@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">
        
<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-package"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($items->count())</h2>
                <p>Product Count</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.2%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($itemsQuantity)</h2>
                <p>Item Quantity</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($itemsPrice)</h2>
                <p>Revenue</p>
                <h5><span class="low"><i class="icon-trending-down"></i> 5.7%</span> since last week</h5>
            </div>
        </div>
    </div>							
</div>
<!-- Row end -->
   
    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Products</th>
                                  <th>Quantity </th>
                                  <th>Unit Price</th>
                                  <th>Totals</th>													  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{@strtoupper($item->name)}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$item->quantity}}
                                  </td>
                                  <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->price)</td>
                                  <td>
                                  {{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->total)
                                  </td>													  
                                </tr>
                                @endforeach
                               
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection