@extends('layouts.app')

@section('content')

<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">
<?php $userSummary = \DB::table('users')->where('id', request('user_id'))->first(); ?>


<!-- Content wrapper start -->
<div class="content-wrapper">

@if(!empty(request('user_id')))
<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

        <div class="profile-header">
            <h1>Product Summary</h1>
            <div class="profile-header-content">
                <div class="profile-header-tiles">
                    <div class="row gutters">
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            <div class="profile-tile">
                                <span class="icon">
                                    <i class="icon-server"></i>
                                </span>
                                <h6>Name - <span>{{@strtoupper($userSummary->name)}}</span></h6>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            <div class="profile-tile">
                                <span class="icon">
                                    <i class="icon-map-pin"></i>
                                </span>
                                <h6>Current Outlet - <span>{{$userSummary->branch}}</span></h6>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
                            <div class="profile-tile">
                                <span class="icon">
                                    <i class="icon-phone1"></i>
                                </span>
                                <h6>Date - <span>{{request('date')}}</span></h6>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="profile-avatar-tile">
                    <img src="/img/user1.png" class="img-fluid" alt="User Profile" />
                </div>
            </div>
        </div>

    </div>
</div>
@endif
<!-- Row end -->

<!-- Row start -->
<div class="row gutters">
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-package"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($items->count())</h2>
                <p>Product Count</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.2%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-shopping-bag1"></i>
            </div>
            <div class="sale-details">
                <h2>@convert($items->sum('quantity'))</h2>
                <p>Items Quantity</p>
                <h5><span class="high"><i class="icon-trending-up"></i> 7.5%</span> since last week</h5>
            </div>
        </div>
    </div>
    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-12">
        <div class="stats-tile">
            <div class="sale-icon">
                <i class="icon-briefcase"></i>
            </div>
            <div class="sale-details">
                <h2>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($items->sum('total'))</h2>
                <p>Revenue</p>
                <h5><span class="low"><i class="icon-trending-down"></i> 5.7%</span> since last week</h5>
            </div>
        </div>
    </div>							
</div>
<!-- Row end -->

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                    <table id="copy-print-csv" class="table v-middle">
                            <thead>
                                <tr>
                                  <th>Products</th>
                                  <th>Quantity </th>
                                  <th>Unit Price</th>
                                  <th>Totals</th>													  
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($items as $item)
                                <tr>
                                  <td>
                                      <div class="media-box">
                                          <div class="media-box-body">
                                              <a href="#" class="text-truncate">{{$item->name}}</a>
                                          </div>
                                      </div>
                                  </td>
                                  <td>
                                  {{$item->quantity}}
                                  </td>
                                  <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->price)</td>
                                  <td>
                                  {{empty($app->currency) ? "GHS" : $app->currency}}@convert($item->total)
                                  </td>													  
                                </tr>
                                @endforeach
                            </tbody>
                    </table>
                    </div>

                </div>
            </div>

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


@endsection