@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">


<div class="alert alert-light alert-dismissible fade show" role="alert">
   <p> Ability to define and Manage sales target gives your business the much needed performance indicator for fast growth. A growing business needs performance indicator to determine health and growth of a business. This indicator can be at the company level or at the store level.</p>
    <div id="changestatus">
    <div class="form-check form-check-inline" >
        @if( $app->sales_target == 1 )
        <input class="form-check-input" <?= $app->sales_target == 1 ? 'checked' : ''  ?>  type="checkbox" id="s_target" onchange="DeactivateTarget()">
        @else
        <input class="form-check-input"  type="checkbox" id="s_target" onchange="activateTarget()">
        @endif
        <label class="form-check-label" for="salesTarget" >{{$app->sales_target == 1 ? "Disable Sales Target Management": "Enable Sales Target Management"}}</label>
    </div>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>

    <!-- Row start -->
    <div class="row gutters">
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Sales Target</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="highlightRowColumn" class="table custom-table">
                    <thead>
                        <tr>
                        <th>Branch</th>
                            <th>Month</th>
                            <th>Amount</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($targets as $target)
                        <tr>
                        <td>{{$target->target_branch}}</td>
                            <td>{{date("F", mktime(0,0,0, $target->target_month, 10))}}</td>
                            <td>@convert($target->target_amount)</td>
                            <td>
                            <div class="actions">
                                <a href="#" data-toggle="tooltip" id="{{$target->id}}" onclick="DeleteTarget(this.id)" data-placement="top" title="" data-original-title="Delete">
                                    <i class="icon-x-circle text-danger"></i>
                                </a>
                            </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">New Target</div>
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                        <form id="month-target">
                            @csrf
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <select class="form-control @error('Branch') is-invalid @enderror" name="branch_name" required>
									<option selected disable>Select Outlet</option>
									    @foreach($all_branch as $branch)
										<option value="{{$branch}}">{{$branch}}</option>
										@endforeach
                                    </select>

                                <div class="field-placeholder">Outlet <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                            <select name="target_month" required class="form-control">
                                <option disabled selected>Choose Month</option>
                                <option value="1 - <?php echo date("Y");?>">January <?php echo date("Y");?></option>
                                <option value="2 - <?php echo date("Y");?>">February <?php echo date("Y");?></option>
                                <option value="3 - <?php echo date("Y");?>">March <?php echo date("Y");?></option>
                                <option value="4 - <?php echo date("Y");?>">April <?php echo date("Y");?></option>
                                <option value="5 - <?php echo date("Y");?>">May <?php echo date("Y");?></option>
                                <option value="6 - <?php echo date("Y");?>">June <?php echo date("Y");?></option>
                                <option value="7 - <?php echo date("Y");?>">July <?php echo date("Y");?></option>
                                <option value="8 - <?php echo date("Y");?>">August <?php echo date("Y");?></option>
                                <option value="9 - <?php echo date("Y");?>">September <?php echo date("Y");?></option>
                                <option value="10 - <?php echo date("Y");?>">October <?php echo date("Y");?></option>
                                <option value="11 - <?php echo date("Y");?>">November <?php echo date("Y");?></option>
                                <option value="12 - <?php echo date("Y");?>">December <?php echo date("Y");?></option>
                            </select>
                                <div class="field-placeholder">Target Month <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>


                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                        
                            <!-- Field wrapper start -->
                            <div class="field-wrapper">
                                <input class="form-control" required type="number" step="0.01" name="target_amount">
                                <div class="field-placeholder">Amount <span class="text-danger">*</span></div>
                            </div>
                            <!-- Field wrapper end -->

                        </div>

                      
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                            <button class="btn btn-primary" >Submit</button>
                        </div>
                        </form>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->


<script type="text/javascript">
    
    $("#month-target").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('store.target')}}",
                dataType: "json",
                data: $('#month-target').serialize(),
                success: function(data){
                    $("#month-target")[0].reset();
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'New Sales Target Added Successfully'
                    })
                    
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });



        function DeleteTarget(id) {
            Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    Swal.fire(
                        'Deleted!',
                        'Branch Deleted Suceessfully',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/delete-target/"+id);
                xhttp.send();
            }
            })
            
        }


        function DeactivateTarget() {
            Swal.fire({
            title: 'Are you sure?',
            text: "By Disabling, sales target cannot be managed",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Disable Target!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#changestatus").load(" #changestatus");
                    Swal.fire(
                        'Disabled!',
                        'Sales Target Management Disabled',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/activate-target");
                xhttp.send();
            }
            })
        }


        function activateTarget() {
            Swal.fire({
            title: 'Are you sure?',
            text: "By activating sales target, you must set target for outlets",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Activate Target!'
            }).then((result) => {
            if (result.isConfirmed) {
                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                    $("#changestatus").load(" #changestatus");
                    Swal.fire(
                        'Enabled!',
                        'Sales Target Management Enabled',
                        'success'
                        )
                }
                xhttp.open("GET", "/ceqa-dashboard/activate-target");
                xhttp.send();
            }
            })
        }
</script>


@endsection