@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="container">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    <div class="card-title">TRANSACTION NO. #{{$invoice_number}}</div>
                        @if($customer_id == null)
                        @if(auth()->user()->role == "Cashier")
                        <a href="{{route('showPrintDesign', $invoice_number)}}" class="btn btn-outline-primary btn sm">
                        <i class="icon-printer" aria-hidden="true"></i>
                        Accept Payment & Print Receipt</a>
                        @else
                        <a href="{{route('showPrintDesign', $invoice_number)}}" class="btn btn-outline-primary btn sm">
                        <i class="icon-printer" aria-hidden="true"></i>
                        Print Receipt</a>
                        @endif
                        @else
                        @if(auth()->user()->role == "Cashier")
                        <a href="/ceqa-dashboard/print-invoice/delivery/<?= $invoice_number ?>/<?= $customer_id ?>" class="btn btn-outline-primary btn sm">
                        <i class="icon-printer" aria-hidden="true"></i>
                        Accept Payment & Print Receipt</a>
                        @else
                        <a href="/ceqa-dashboard/print-invoice/delivery/<?= $invoice_number ?>/<?= $customer_id ?>" class="btn btn-outline-primary btn sm">
                        <i class="icon-printer" aria-hidden="true"></i>
                        Print Receipt</a>
                        @endif
                        @endif
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Product ID.</th>
                                <th>Ordered Date</th>
                                <th>Product</th>
                                <th>Quantity</th>												
                                <th> Unit Price</th>
                                <th>Total Price</th>
                                @if(auth()->user()->role !== "Sales Person")
                                <th>Action</th>
                                @endif
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $list)
                            <tr>
                                <td>#{{$list->invoice_number}}</td>
                                <td>{{$list->created_at}}</td>
                                <td>
                                {{$list->invoice_product_name}}
                                </td>
                                <td>
                                {{$list->invoice_quantity}}
                                </td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_unit_price}}</td>
                                <td>{{empty($app->currency) ? "GHS" : $app->currency}}{{$list->invoice_total_price}}</td>
                                @if(auth()->user()->role !== "Sales Person")
                                <td>
                                    <button onclick="getOrderId(this.id)" id="{{$list->id}}" class="btn btn-default text-danger" data-bs-toggle="modal" data-bs-target="#exampleModalchangestatus">
                                    <i class="fa fa-edit"></i>
                                    </button>
                                </td>
                                @endif
                            </tr>
                            @endforeach
                        </tbody> 
                    </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>


        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->




<!-- Modal start -->
<div class="modal fade" id="exampleModalchangestatus" tabindex="-1" aria-labelledby="exampleModalSmallTitle" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalSmallTitle">Change Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
               <form id="change">
               <input type="text" name="invoice_id" id="id" readonly hidden>
                 <!-- Field wrapper start -->
                @csrf
                <div class="field-wrapper">
                    <div class="input-group">
                        <select name="status" class="select-single js-states">
                            <option value="General">General</option>
                            @if(auth()->user()->role == "Administrator")
                            <option value="Rejected">Rejected</option>
                            @endif
                        </select>
                    </div>
                    <div class="field-placeholder">Status</div>
                </div>
                <!-- Field wrapper end -->

                <div class="field-wrapper">
                    <div class="input-group">
                        <textarea name="comment" cols="30" rows="10" required></textarea>
                    </div>
                    <div class="field-placeholder">Comment</div>
                </div>
                <!-- Field wrapper end -->

                <button class="btn btn-primary btn-sm">Save Changes</button>
               </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal end -->



<script>
    function getOrderId(id) {
        document.getElementById('id').value = id
    }


    $("#change").on('submit', function(event) {
            event.preventDefault();
            $.ajax({
                type: "post",
                url: "{{route('changeInvoiceStatus')}}",
                dataType: "json",
                data: $('#change').serialize(),
                success: function(data){
                    if (data == 0) {
                        window.location.href = "/ceqa-dashboard/rejected-bom";
                    }else{
                    $("#highlightRowColumn").load(" #highlightRowColumn");
                    const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                    })

                    Toast.fire({
                    icon: 'success',
                    title: 'Item Status Changed Successfully'
                    })
                }
                    
                },
                error: function(data){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Something went wrong!',
                    footer: '<a href="">Why do I have this issue?</a>'
                    })
                }
            });
        });
</script>


@endsection