@extends('layouts.app')

@section('content')


<!-- Content wrapper scroll start -->
<div class="content-wrapper-scroll">

<!-- Content wrapper start -->
<div class="content-wrapper">

    <!-- Row start -->
    <div class="row gutters">
        <div class="container">

            <!-- Card start -->
            <div class="card">
                <div class="card-header">
                    @if($pendings == null)
                    <div class="card-title">No Pending Order Associated with your Account</div>
                    @else
                    <div class="card-title">Pending Orders</div>
                    @endif
                </div>
                <div class="card-body">
                    
                    <!-- Row start -->
                    <div class="row gutters">
                    <table id="copy-print-csv" class="table v-middle">
                        <thead>
                            <tr>
                                <th>Invoice No.</th>
                                <th>Branch</th>
                                <th>Category</th>
                                <th>Ordered at</th>												
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($pendings as $list)
                            <tr>
                                <td>#{{$list->order_id}}</td>
                                <td>{{$list->branch}}</td>
                                <td>
                                {{$list->category}}
                                </td>
                                <td>
                                <span class="badge rounded-pill bg-info">
                                    {{\Carbon\Carbon::parse($list -> created_at)->diffForHumans()}}
                                </span>
                                </td>
                                <td>
                                <a href="#" class="btn btn-primary btn-sm"><i class="fa fa-ban" aria-hidden="true"></i> Mark as Rejected</a>
                                <a href="{{route('orderTransaction', $list->order_id)}}" class="btn btn-success btn-sm"><i class="fa fa-eye" aria-hidden="true"></i></a>
                                <a href="{{route('markReady', $list->id)}}" class="btn btn-info btn-sm"><i class="fa fa-check" aria-hidden="true"></i>Mark as Ready</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                    <!-- Row end -->

                </div>
            </div>
            <!-- Card end -->

        </div>


        </div>
    </div>
    <!-- Row end -->

</div>
<!-- Content wrapper end -->



@endsection