<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Print Receipt</title>

    <!-- Bootstrap css -->
    <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">

    <!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />
    
		<!-- Sweet Alert-->
		<link href="{{asset('vendor/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />

		
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('fonts/style.css')}}">

		<!-- Main css -->
		<link rel="stylesheet" href="{{asset('css/main.css')}}">

		<!-- fontAwesome -->
    <link href="{{asset('fontawesome/css/all.css')}}" rel="stylesheet">
  <style>
    .container {
      display: flex;
      justify-content: center;
    }


    .footer {
      position: fixed;
      left: 0;
      bottom: 0;
      width: 100%;
      background-color: #073a82;
      color: white;
      text-align: center;
      padding:10px
    }

    table{
      font-size:10px;
    }


    @media print {
      body * {
        visibility: hidden;
      }
      #section-to-print, #section-to-print * {
        visibility: visible;
      }
      #section-to-print {
        position: absolute;
        left: 0;
        top: 0;
      }
    }
  </style>
</head>
<body onLoad="window.print();">
  @include('inc.errorfile')
<div class="container" id="section-to-print">
  
    <div class="child">

    <table width="250" border="0" cellspacing="0" cellpadding="0" style="font-family:Arial, Helvetica, sans-serif; font-size:12px;">
    <tr>
    <td><table width="100%" border="0" cellspacing="0" cellpadding="4">
      <tr>
        <td align="center"><h4>{{$app->app_name}}</h4></td>
      </tr>
      <tr>
      <td align="center" style="font-size:17px;">ORDER NO: <strong>{{$display_waiting}}</strong></td>
      </tr>
      <tr>
        <td align="center">
        <div>
            <strong><?= $branch_details -> branch_name ?></strong><br>
            <?= $branch_details -> branch_location ?></br>
            Phone   : <?= $branch_details -> branch_contact ?></br>
            Momo Number  : <?= $branch_details -> branch_momo ?></br>
        </div>
      
      </td>
    </tr>
    <tr>
      <td align="center">Receipt Number: <strong>#{{$number}}</strong> <input type="text" readonly hidden id="receipt_n" value="{{$number}}"></td>
    </tr>
    <tr>
    <td align="center">TIN: <strong><?= $branch_details -> tin_number ?></strong></td>
    </tr>
  </table></td>
  </tr>
  <tr>
  <td><table width="100%" border="0"  cellspacing="0" cellpadding="5" style="font-size:10px">
    <tr>
      <td>
      PHARMACIST:
         <?php 
      $f_name = explode(" ", $sales_person_name);
      echo @strtoupper($f_name[0]);
      ?>
      
      <h5><em>{{empty($agency_->agency) ?  "" : "DELIVERY AGENT: " . $agency_->agency}}</em></h5>

    </td>

    </tr>
    <tr>
      <td><?= @strtoupper($time) ?></td>
      <!-- use $time if you waant buying date -->
    </tr>
  </table>
  </td></tr>

  <tr>
  <td>
    
  <table width="100%" border="0" cellspacing="0" cellpadding="5" style="border-top:solid 1px #000; border-bottom:solid 1px #000; font-size:10px">
    <tr>
      <td><strong>ITEM</strong></td>
      <td><strong>QTY</strong></td>
      <td><strong>RATE</strong></td>
      <td align="right"><strong>TOTAL</strong></td>
    </tr>
    @foreach($invoice_generate as $invoice)
    <tr>
      <td>{!!@strtoupper($invoice->invoice_product_name)!!}</td>
      <td>{{$invoice->invoice_quantity}}</td>
      <td>@convert($invoice->invoice_unit_price)</td>
      <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($invoice->invoice_total_price)</td>
    </tr>
    @endforeach
  </table>
  
  </td>
  </tr>
  <tr>
  <td>
  
  <table width="100%" border="0" cellspacing="0" cellpadding="4" style="font-size:10px">
    <tr>
      @if($discount == null)
      <td><strong>DISCOUNT</strong></td>
      <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}} 0,00</td>
      @else
      <?php 
        if ($discount->type == "Cash") {
          echo '<td>' . '<strong>' . "DISCOUNT" . '</strong>' . '</td>';
          echo '<td align="right">' . $discount->discount . '</td>';
        }elseif ($discount->type == "Percentage") {
          echo '<td>' . '<strong>' . "DISCOUNT" . '</strong>' . '</td>';
          echo '<td align="right">' . $discount->discount . "%". '</td>';
        }
        ?>
      @endif
    </tr>
    @if($discount != null)
    <tr>
    <td><strong>DISCOUNT SUBTOTAL</strong></td>
    <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</td>
    </tr>
    @endif
    <tr>
    @if($discount == null)
      <td><strong>VAT EXCL. TOTAL</strong></td>
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)))</strong></td>
      @else
      <td><strong>VAT EXCL. TOTAL</strong></td>
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($discount->amount_paid)/(1+($gTax) + ($mTax->vat) + ($gTax)*($mTax->vat))) </strong></td>
      @endif
    </tr>
    <tr>
      <td></td>
      @if($discount == null)
      <tr>
        <td>COVID LEVY  <strong>1%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</td>
      </tr>
      <tr>
        <td>GETFUND LEVY <strong>2.5%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</td>
      </tr>
      <tr>
        <td>NHIL LEVY <strong>2.5%</strong></td>
        <td align="right" style="text-decoration:underline">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</td>
      </tr>
      <tr>
        <td></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(((($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid) + (($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund) + (($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)) + ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)))</td>
      </tr>
      <tr>
        <td>VAT <strong>12.5%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}} ₵@convert((((($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid) + (($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund) + (($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)) + ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))) * $mTax->vat)</td>
      </tr>
      @else
      <tr>
        <td>COVID LEVY  <strong>1%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</td>
      </tr>
      <tr>
        <td>GETFUND LEVY <strong>2.5%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</td>
      </tr>
      <tr>
        <td>NHIL LEVY <strong>2.5%</strong></td>
        <td align="right" style="text-decoration:underline">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</td>
      </tr>
      <tr>
        <td></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(((($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid) + (($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund) + (($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)) + ($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)))</td>
      </tr>
      <tr>
        <td>VAT <strong>12.5%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}} ₵@convert((((($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid) + (($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund) + (($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)) + ($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))) * $mTax->vat)</td>
      </tr>
      @endif
    </tr>
    <tr>
      <td><strong>VAT INCL. TOTAL</strong></td>
      @if($discount == null)
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total)</strong></td>
      @else
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</strong></td>
      @endif
    </tr>
  </table>
  
</td>
  </tr>

  <tr>
  <td>
    
  <table width="100%" border="0" cellspacing="0" cellpadding="1">
    <tr>
      <td style="border-bottom:solid 1px #000;"> </td>
    </tr>
    <tr>
      <td align="center">{{$app->app_receipt_footer}}</td>
    </tr>
  </table>
  </td>
  </tr>

  </table>

  </div>
</div>

  


<div class="footer">
  <p>

  @if(auth()->user()->role == "Cashier")
  <a href="{{route('index.cashier')}}" class="btn btn-success rounded-pill stripes-btn">Order Display</a>

  <button onclick="display()" class="btn btn-danger rounded-pill stripes-btn">
  <i class="fa fa-print" aria-hidden="true"></i>Print Order
  </button>
  @endif
  
  @if(auth()->user()->sales_person_category == "Drive Thru")
  <button type="button" class="btn btn-primary rounded-pill stripes-btn" data-bs-toggle="modal" data-bs-target="#exampleModalFullScreen">
  <i class="fas fa-users"></i> Add Customer
	</button>
  
  <a href="#" class="btn btn-primary rounded-pill stripes-btn"  data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Invoice</a>

  <a href="#" class="btn btn-secondary stripes-bn" data-bs-toggle="modal" data-bs-target="#staticBackdrop"><i class="icon-attach_money"></i>Accept Payment</a>
  @elseif(auth()->user()->role == "Branch Officer")
  <a href="#" onclick="viewOrders()"  class="btn btn-primary rounded-pill stripes-btn">Back to Orders</a>
  @else
  @if(auth()->user()->role == "Sales Person")
  <a href="#" class="btn btn-primary rounded-pill stripes-btn"  data-bs-toggle="modal" data-bs-target="#DeliveryModalGeneral">New Invoice</a>
  @endif
  <a href="#" class="btn btn-secondary rounded-pill stripes-btn" data-bs-toggle="modal" data-bs-target="#staticBackdrop"><i class="icon-attach_money"></i>Accept Payment</a>
  @endif
  </p>
</div>


@include('inc.new-customer')
@include('modal.delivery-modal')
@include('tingg.tingg-modal')

  <script>
         function display() {
          window.print();
         }


         function newInvoice() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You Want to Create New Invoice!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, Create Invoice!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "{{route('index.invoice')}}";
              }
            })
         }


         function viewOrders() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You Want to View Orders!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, View Orders!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "/orders-from-counter/check-to-complete";
              }
            })
         }


  </script>

  <!-- Required jQuery first, then Bootstrap Bundle JS -->
  <script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>

    <!-- Bootstrap Select JS -->
		<script src="{{asset('vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('vendor/bs-select/bs-select-custom.js')}}"></script>

    <!-- Sweet Alerts js -->
		<script src="{{asset('vendor/libs/sweetalert2/sweetalert2.min.js')}}"></script>

  <!-- Main Js Required -->
  <script src="{{asset('js/main.js')}}"></script>
</body>
</html>