<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Print Receipt</title>
       <!-- Bootstrap css -->
       <link rel="stylesheet" href="{{asset('css/bootstrap.min.css')}}">

        <!-- Bootstrap Select CSS -->
		<link rel="stylesheet" href="{{asset('vendor/bs-select/bs-select.css')}}" />
    
		<!-- Sweet Alert-->
		<link href="{{asset('vendor/libs/sweetalert2/sweetalert2.min.css')}} " rel="stylesheet" type="text/css" />

		
		<!-- Icomoon Font Icons css -->
		<link rel="stylesheet" href="{{asset('fonts/style.css')}}">


  <style>
    .container {
      display: flex;
      justify-content: center;
    }


    table{
      font-size:12px;
      font-family:'monospace', monospace
    }



    .footer {
      position: fixed;
      left: 0;
      bottom: 0;
      width: 100%;
      background-color: #073a82;
      color: white;
      text-align: center;
      padding:10px
    }


    @media print {
      body * {
        visibility: hidden;
      }
      #section-to-print, #section-to-print * {
        visibility: visible;
      }
      #section-to-print {
        position: absolute;
        left: 0;
        top: 0;
      }
    }
  </style>
</head>
<body onLoad="window.print();">
  
   	<!-- Main css -->
@include('inc.errorfile')
<div class="container" id="section-to-print">
  
    <div class="child">

    <table width="250" border="0" cellspacing="0" cellpadding="0" style="font-family:Arial, Helvetica, sans-serif; font-size:11px;">
    <tr>
    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="center"><h5><strong>{{$app->app_name}}</strong></h5></td>
      </tr>
      <tr>
        <td align="center"><h6><strong>TAX INVOICE</strong></h6></td>
      </tr>
      <tr>
        <td align="center"><label id="re">ORIGINAL RECEIPT</label></td>
      </tr>
      <tr>
        <td align="center"><center>Order No#<h3><?php echo rand(20,900) ?></h3></center></td>
      </tr>
      <tr>
        <td align="center">
        <div>
            <strong><?= $branch_details -> branch_name ?></strong><br>
            <?= $branch_details -> branch_location ?></br>
            Phone   : <?= $branch_details -> branch_contact ?></br>
        </div>
        
        </td>
      </tr>
      <tr>
        <td align="center">Receipt Number: <strong>#{{$number}}</strong><input type="text" readonly hidden id="receipt_n" value="{{$number}}"></td>
      </tr>
      <tr>
        <td align="center">TIN: <strong><?= $branch_details -> tin_number ?></strong></td>
    </tr>
    </table></td>
    </tr>
    <tr>
    <td><table width="100%" border="0" cellspacing="0" cellpadding="5" style="font-size:11px">
      <tr>
      <td>
          SALES PERSON:
            <?php 
            $f_name = explode(" ", $sales_person_name);
            echo @strtoupper($f_name[0]);
          ?> <br>
          <span><em>{{ empty($agency_->agency) ?  "" : "Payment Method: " . $agency_->agency}}</em></span>
      </td>
        <td><?= $time ?></td>
      </tr>
      
    </table>
    </td></tr>
    
    <tr>
    <td>
      
    <table width="100%" border="0" cellspacing="0" cellpadding="2" style="border-top:solid 1px #000; border-bottom:solid 1px #000; font-size:11px;">
      <tr>
      <td><strong>ITEM</strong></td>
      <td><strong>QTY</strong></td>
      <td><strong>RATE</strong></td>
      <td align="right"><strong>TOTAL</strong></td
      </tr>
      <?php $total = 0 ?>
      @foreach($invoice_generate as $invoice)
      <?php $total += $invoice->invoice_unit_price *  $invoice->invoice_quantity?>
      <tr>
      <td>{!!@strtoupper($invoice->invoice_product_name)!!}</td>
      <td>{{$invoice->invoice_quantity}}</td>
      <td>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($invoice->invoice_unit_price)<strong>{{$invoice->invoice_status == 2 ? "NC" : ""}}</td>
      <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($invoice->invoice_total_price)<strong>{{$invoice->invoice_status == 2 ? "NC" : ""}}</strong></td>
      </tr>
      @endforeach
    </table>
    
    </td>
    </tr>
    <tr>
    <td>
      
    <table width="100%" border="0" cellspacing="0" cellpadding="1" style="font-size:11px;">
    <tr>
      @if($discount == null)
      <td><strong>DISCOUNT</strong></td>
      <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert(0)</td>
      <td></td>
      <td></td>
      @else
      <?php 
        if ($discount->type == "Cash") {
          echo '<td>' . '<strong>' . "DISCOUNT" . '</strong>' . '</td>';
          echo '<td align="right">' . $discount->discount . '</td>';
          echo '<td></td';
          echo '<td></td';
        }elseif ($discount->type == "Percentage") {
          echo '<td>' . '<strong>' . "DISCOUNT" . '</strong>' . '</td>';
          echo '<td align="right">' . $discount->discount .'</td>';
          echo '<td></td';
          echo '<td></td';
        }
        ?>
      @endif
    </tr>
    @if($discount != null)
    <tr>
    <td><strong>DISCOUNT SUBTOTAL</strong></td>
    <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</td>
    <td></td>
    </tr>
    @endif
    <tr>
    <?php $TOURISM_ = ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->tourism ?>
    @if($discount == null)
      <td><strong>VAT EXCL. TOTAL</strong></td>
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($EXCLUSIVE_MAIN = ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat)) )</strong></td>

      @else
      <td><strong>VAT EXCL. TOTAL</strong></td>
      <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($EXCLUSIVE_ = ($discount->amount_paid)/(1+($gTax) + ($mTax->vat) + ($gTax)*($mTax->vat)) ) </strong></td>
      @endif
    </tr>
    <tr>
      <td></td>
      @if($discount == null)
      <tr>
        <td>COVID LEVY  <strong>@convert($mTax->covid*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($COVID_ = ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</td>
      </tr>
      <tr>
        <td>GETFUND LEVY <strong>@convert($mTax->getfund*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($GETFUND_ = ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</td>
      </tr>
      <tr>
        <td>NHIL LEVY <strong>@convert($mTax->nhil*100)%</strong></td>
        <td align="right" style="text-decoration:underline">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($NHIL_ = ($total)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</td>
      </tr>
     
      <tr>
        <td></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($TOTAL_TAX_MAIN = $EXCLUSIVE_MAIN+$COVID_+$GETFUND_+$NHIL_+$TOURISM_)</td>
      </tr>
      <tr>
        <td>VAT <strong>@convert($mTax->vat*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($TOTAL_TAX_MAIN * $mTax->vat)</td>
      </tr>
      @else
      <tr>
        <td>COVID LEVY  <strong>@convert($mTax->covid*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($COVID_ =($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->covid)</td>
      </tr>
      <tr>
        <td>GETFUND LEVY <strong>@convert($mTax->getfund*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($GETFUND_ = ($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->getfund)</td>
      </tr>
      <tr>
        <td>NHIL LEVY <strong>@convert($mTax->nhil*100)%</strong></td>
        <td align="right" style="text-decoration:underline">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($NHIL_ = ($discount->amount_paid)/(1+ ($gTax) + ($mTax->vat) + ($gTax*$mTax->vat))*$mTax->nhil)</td>
      </tr>
      
      <tr>
        <td></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($TOTAL_TAX_ = $EXCLUSIVE_+$COVID_+$GETFUND_+$NHIL_+$TOURISM_)</td>
      </tr>
      <tr>
        <td>VAT <strong>@convert($mTax->vat*100)%</strong></td>
        <td align="right">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($TOTAL_TAX_ * $mTax->vat)</td>
      </tr>
      @endif
    </tr>
    <tr>
      <td><strong>VAT INCL. TOTAL</strong></td>
      @if($discount == null)
      <td align="right"><strong> <span>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total)</span></strong></td>
      @else
      <td align="right"><strong> <span>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid)</span></strong></td>
      @endif
    </tr>
    
      <tr>
        <td><strong>AMOUNT PAID</strong></td>
        <td align="right"><span style="text-decoration:underline">{{empty($app->currency) ? "GHS" : $app->currency}}@convert($amount_paid->amount_paid)</span></td>
      </tr>
      <tr>
        <td><strong>BALANCE DUE</strong></td>
        @if($discount == null)
        <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($total - $amount_paid->amount_paid)</strong></td>
        @else
        <td align="right"><strong>{{empty($app->currency) ? "GHS" : $app->currency}}@convert($discount->amount_paid - $amount_paid->amount_paid)</strong></td>
        @endif
      </tr>
      @if($customer -> customer_name !== "WALK-IN CUSTOMER")
    <tr>
        <td> </td>
        <td> </td>
      </tr>
      <tr>
        <td>CUSTOMER NAME:</td>
        <td align="right">{{$customer -> customer_name}}</td>
      </tr>
      <tr>
        <td>LOCATION:</td>
        <td align="right">{{$customer -> customer_address}}</td>
      </tr>
      <tr>
        <td>PHONE:</td>
        <td align="right"><strong>{{$customer -> customer_phone}}</strong></td>
      </tr>
      <tr>
        <td>NOTE:</td>
        <td align="right">{{@strtolower($customer -> customer_note)}} </td>
      </tr>
      @endif
    </table>
    
  </td>
    </tr>

    <tr>
    <td>
      
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td style="border-bottom:solid 1px #000;"> </td>
      </tr>
      <tr>
        <td align="center">{!!$app->app_receipt_footer!!}</td>
      </tr>
      
       
    
    </table>
      
    </td>
    </tr>
    </table>

    </div>
</div>
  


<div class="footer">
  <p>
  <button onclick="display()" class="btn btn-success">
  	<i class="icon-print" aria-hidden="true"></i>Print
  </button>
  
     <a href="#" class="btn btn-primary stripes-btn" onclick="newInvoice()">New Sale</a>
   </p>
</div>


@include('tingg.tingg-modal')
  

  <script>

         function display() {
             document.getElementById('re').innerHTML
                = 'DUPLICATE RECEIPT';
          window.print();
         }


         function newInvoice() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You want to create new sale!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, new sale!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "/";
              }
            })
         }
         
          function callInvoice() {
          Swal.fire({
              title: 'Are you sure?',
              text: "You want to create new sale!",
              icon: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: 'Yes, new sale!'
            }).then((result) => {
              if (result.isConfirmed) {
                window.location.href = "/";
              }
            })
         }


         function getValueTWO() {
            var e = document.getElementById("sale_type22");
            if (e.value === "CREDIT NOTE") {
                $('#submitTicketModal').modal('show');

                const xhttp = new XMLHttpRequest();
                xhttp.onload = function() {
                   
                }
                xhttp.open("GET", "/ceqa-dashboard/sale-type/cash-sales");
                xhttp.send();
            }else{
                console.log("error")
            }
        }
  </script>
      <!-- Required jQuery first, then Bootstrap Bundle JS -->
  <script src="{{asset('js/jquery.min.js')}}"></script>
		<script src="{{asset('js/bootstrap.bundle.min.js')}}"></script>
		<script src="{{asset('js/modernizr.js')}}"></script>
		<script src="{{asset('js/moment.js')}}"></script>


        <!-- Bootstrap Select JS -->
		<script src="{{asset('vendor/bs-select/bs-select.min.js')}}"></script>
		<script src="{{asset('vendor/bs-select/bs-select-custom.js')}}"></script>

    <!-- Sweet Alerts js -->
		<script src="{{asset('vendor/libs/sweetalert2/sweetalert2.min.js')}}"></script>

  <!-- Main Js Required -->
  <script src="{{asset('js/main.js')}}"></script>
</body>
</html>